/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.base.Preconditions;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.CollectPreconditions;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.primitives.Ints;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible
public abstract class DiscreteDomain<C extends Comparable> {
    final boolean supportsFastOffset;

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    protected DiscreteDomain() {
        this(false);
    }

    private DiscreteDomain(boolean supportsFastOffset) {
        this.supportsFastOffset = supportsFastOffset;
    }

    C offset(C origin, long distance) {
        CollectPreconditions.checkNonnegative(distance, "distance");
        for (long i2 = 0L; i2 < distance; ++i2) {
            origin = this.next(origin);
        }
        return origin;
    }

    public abstract C next(C var1);

    public abstract C previous(C var1);

    public abstract long distance(C var1, C var2);

    @CanIgnoreReturnValue
    public C minValue() {
        throw new NoSuchElementException();
    }

    @CanIgnoreReturnValue
    public C maxValue() {
        throw new NoSuchElementException();
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        BigIntegerDomain() {
            super(true);
        }

        @Override
        public BigInteger next(BigInteger value) {
            return value.add(BigInteger.ONE);
        }

        @Override
        public BigInteger previous(BigInteger value) {
            return value.subtract(BigInteger.ONE);
        }

        @Override
        BigInteger offset(BigInteger origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, "distance");
            return origin.add(BigInteger.valueOf(distance));
        }

        @Override
        public long distance(BigInteger start, BigInteger end2) {
            return end2.subtract(start).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.bigIntegers()";
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        LongDomain() {
            super(true);
        }

        @Override
        public Long next(Long value) {
            long l = value;
            return l == Long.MAX_VALUE ? null : Long.valueOf(l + 1L);
        }

        @Override
        public Long previous(Long value) {
            long l = value;
            return l == Long.MIN_VALUE ? null : Long.valueOf(l - 1L);
        }

        @Override
        Long offset(Long origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, "distance");
            long result2 = origin + distance;
            if (result2 < 0L) {
                Preconditions.checkArgument(origin < 0L, "overflow");
            }
            return result2;
        }

        @Override
        public long distance(Long start, Long end2) {
            long result2 = end2 - start;
            if (end2 > start && result2 < 0L) {
                return Long.MAX_VALUE;
            }
            if (end2 < start && result2 > 0L) {
                return Long.MIN_VALUE;
            }
            return result2;
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.longs()";
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        IntegerDomain() {
            super(true);
        }

        @Override
        public Integer next(Integer value) {
            int i2 = value;
            return i2 == Integer.MAX_VALUE ? null : Integer.valueOf(i2 + 1);
        }

        @Override
        public Integer previous(Integer value) {
            int i2 = value;
            return i2 == Integer.MIN_VALUE ? null : Integer.valueOf(i2 - 1);
        }

        @Override
        Integer offset(Integer origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, "distance");
            return Ints.checkedCast(origin.longValue() + distance);
        }

        @Override
        public long distance(Integer start, Integer end2) {
            return (long)end2.intValue() - (long)start.intValue();
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.integers()";
        }
    }
}

