/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharacterEntityReference;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Config;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.NumericCharacterReference;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StreamedSource;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source2, int n, int n2, int n3) {
        super(source2, n, n2);
        this.codePoint = n3;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public final void appendCharTo(Appendable appendable) throws IOException {
        this.appendCharTo(appendable, Config.ConvertNonBreakingSpaces);
    }

    private void appendCharTo(Appendable appendable, boolean bl) throws IOException {
        if (Character.isSupplementaryCodePoint(this.codePoint)) {
            appendable.append(CharacterReference.getHighSurrogate(this.codePoint));
            appendable.append(CharacterReference.getLowSurrogate(this.codePoint));
        } else {
            char c = this.getChar();
            if (c == '\u00a0' && bl) {
                appendable.append(' ');
            } else {
                appendable.append(c);
            }
        }
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence charSequence) {
        return CharacterReference.encode(charSequence, true);
    }

    public static String encode(CharSequence charSequence, boolean bl) {
        if (charSequence == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode((Appendable)new StringBuilder(charSequence.length() * 2), charSequence, bl).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String encode(char c) {
        try {
            return CharacterReference.appendEncode((Appendable)new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH), c, true).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 2);
            int n = 0;
            int n2 = charSequence.length();
            if (charSequence instanceof Segment) {
                int c;
                Segment segment = (Segment)charSequence;
                n = c = segment.getBegin();
                n2 += c;
                charSequence = segment.source;
            }
            for (int j = n; j < n2; ++j) {
                int n3;
                char c = charSequence.charAt(j);
                if (!CharacterReference.isWhiteSpace(c)) {
                    CharacterReference.appendEncode((Appendable)stringBuilder, c, false);
                    continue;
                }
                int n4 = j + 1;
                if (c != ' ') {
                    if (c != '\t') {
                        if (c == '\r' && n4 < n2 && charSequence.charAt(n4) == '\n') {
                            ++j;
                        }
                        stringBuilder.append((CharSequence)"<br />");
                        continue;
                    }
                    n3 = 4;
                } else {
                    n3 = 1;
                }
                while (n4 < n2) {
                    c = charSequence.charAt(n4);
                    if (c == ' ') {
                        ++n3;
                    } else {
                        if (c != '\t') break;
                        n3 += 4;
                    }
                    ++n4;
                }
                if (n3 == 1) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (n3 % 2 == 1) {
                    stringBuilder.append(' ');
                }
                while (n3 >= 2) {
                    stringBuilder.append((CharSequence)"&nbsp; ");
                    n3 -= 2;
                }
                j = n4 - 1;
            }
            return ((Object)stringBuilder).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String decode(CharSequence charSequence) {
        return CharacterReference.decode(charSequence, false, Config.ConvertNonBreakingSpaces);
    }

    public static String decode(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(charSequence, bl, Config.ConvertNonBreakingSpaces);
    }

    static final String decode(CharSequence charSequence, boolean bl, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        String string = charSequence.toString();
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        try {
            return CharacterReference.appendDecode((Appendable)new StringBuilder(charSequence.length()), charSequence, n, bl, bl2).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String decodeCollapseWhiteSpace(CharSequence charSequence) {
        return CharacterReference.decodeCollapseWhiteSpace(charSequence, Config.ConvertNonBreakingSpaces);
    }

    static String decodeCollapseWhiteSpace(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuilder(charSequence.length()), charSequence), false, bl);
    }

    public static String reencode(CharSequence charSequence) {
        return CharacterReference.encode(CharacterReference.decode(charSequence, true), true);
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int n) {
        String string = null;
        if (n != 39) {
            string = CharacterEntityReference.getCharacterReferenceString(n);
        }
        if (string == null) {
            string = NumericCharacterReference.getCharacterReferenceString(n);
        }
        return string;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int n) {
        try {
            return CharacterReference.appendDecimalCharacterReferenceString(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int n) {
        try {
            return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int n) {
        try {
            return CharacterReference.appendUnicodeText(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static final Appendable appendUnicodeText(Appendable appendable, int n) throws IOException {
        appendable.append("U+");
        String string = Integer.toString(n, 16).toUpperCase();
        for (int j = 4 - string.length(); j > 0; --j) {
            appendable.append('0');
        }
        appendable.append(string);
        return appendable;
    }

    public static CharacterReference parse(CharSequence charSequence) {
        return CharacterReference.construct(new Source(charSequence, true), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence charSequence) {
        CharacterReference characterReference = CharacterReference.parse(charSequence);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    @Deprecated
    public static final boolean requiresEncoding(char c) {
        return Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(c, true);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    static Appendable appendEncode(Appendable appendable, CharSequence charSequence, boolean bl) throws IOException {
        if (charSequence == null) {
            return appendable;
        }
        int n = 0;
        int n2 = charSequence.length();
        if (charSequence instanceof Segment) {
            int n3;
            Segment segment = (Segment)charSequence;
            n = n3 = segment.getBegin();
            n2 += n3;
            charSequence = segment.source;
        }
        for (int j = n; j < n2; ++j) {
            CharacterReference.appendEncode(appendable, charSequence.charAt(j), bl);
        }
        return appendable;
    }

    private static final Appendable appendEncode(Appendable appendable, char c, boolean bl) throws IOException {
        if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(c, bl)) {
            String string = CharacterEntityReference.getName(c);
            if (string != null && c != '\'') {
                CharacterEntityReference.appendCharacterReferenceString(appendable, string);
            } else {
                CharacterReference.appendDecimalCharacterReferenceString(appendable, c);
            }
        } else {
            appendable.append(c);
        }
        return appendable;
    }

    static CharacterReference getPrevious(Source source2, int n) {
        return CharacterReference.getPrevious(source2, n, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    static CharacterReference getNext(Source source2, int n) {
        return CharacterReference.getNext(source2, n, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    private static CharacterReference getPrevious(Source source2, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source2.getParseText();
        n = parseText.lastIndexOf('&', n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source2, n, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            n = parseText.lastIndexOf('&', n - 1);
        }
        return null;
    }

    private static CharacterReference getNext(Source source2, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source2.getParseText();
        n = parseText.indexOf('&', n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source2, n, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            n = parseText.indexOf('&', n + 1);
        }
        return null;
    }

    static final Appendable appendHexadecimalCharacterReferenceString(Appendable appendable, int n) throws IOException {
        return appendable.append("&#x").append(Integer.toString(n, 16)).append(';');
    }

    static final Appendable appendDecimalCharacterReferenceString(Appendable appendable, int n) throws IOException {
        return appendable.append("&#").append(Integer.toString(n)).append(';');
    }

    static CharacterReference construct(Source source2, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source2.getParseText().charAt(n) != '&') {
                return null;
            }
            return source2.getParseText().charAt(n + 1) == '#' ? NumericCharacterReference.construct(source2, n, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source2, n, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static Appendable appendDecode(Appendable appendable, CharSequence charSequence, int n, boolean bl, boolean bl2) throws IOException {
        if (charSequence instanceof Segment) {
            return CharacterReference.appendDecode(appendable, (Segment)charSequence, n, bl, bl2);
        }
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(bl);
        StreamedSource streamedSource = new StreamedSource(charSequence).setHandleTags(false).setUnterminatedCharacterReferenceSettings(unterminatedCharacterReferenceSettings).setSearchBegin(n);
        for (Segment segment : streamedSource) {
            if (segment instanceof CharacterReference) {
                ((CharacterReference)segment).appendCharTo(appendable, bl2);
                continue;
            }
            appendable.append(segment.toString());
        }
        return appendable;
    }

    private static Appendable appendDecode(Appendable appendable, Segment segment, int n, boolean bl, boolean bl2) throws IOException {
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(bl);
        Source source2 = segment.source;
        ParseText parseText = source2.getParseText();
        int n2 = segment.getEnd();
        int n3 = segment.getBegin();
        int n4 = parseText.indexOf('&', n3 + n, n2);
        while (n4 != -1) {
            CharacterReference characterReference = CharacterReference.construct(source2, n4, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                appendable.append(source2.substring(n3, n4));
                characterReference.appendCharTo(appendable, bl2);
                n3 = characterReference.getEnd();
                n4 = parseText.indexOf('&', n3, n2);
                continue;
            }
            n4 = parseText.indexOf('&', n4 + 1, n2);
        }
        appendable.append(source2.substring(n3, n2));
        return appendable;
    }

    private static char getHighSurrogate(int n) {
        return (char)(55232 + (n >> 10));
    }

    private static char getLowSurrogate(int n) {
        return (char)(56320 + (n & 0x3FF));
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuilder sb = new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char c) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, c, true);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                this.out.append(this.sb);
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.write((char)n);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int j = n; j < n3; ++j) {
                this.write(cArray[j]);
            }
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int j = n; j < n3; ++j) {
                this.write(string.charAt(j));
            }
        }
    }
}

