/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharacterReference;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Tag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.TagType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source2, int n, int n2, EndTagType endTagType, String string) {
        super(source2, n, n2, string);
        this.endTagType = endTagType;
    }

    @Override
    public Element getElement() {
        StartTag startTag;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int n = this.begin;
        while (n != 0 && (startTag = this.source.getPreviousStartTag(n - 1)) != null) {
            Element element = startTag.getElement();
            if (element.getEndTag() == this) {
                return element;
            }
            n = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    @Override
    public TagType getTagType() {
        return this.endTagType;
    }

    @Override
    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        int n;
        String string = this.toString();
        if (this.endTagType != EndTagType.NORMAL) {
            return string;
        }
        if (!CharacterReference.isWhiteSpace(string.charAt(string.length() - 2))) {
            return string;
        }
        for (n = string.length() - 3; n > 0 && CharacterReference.isWhiteSpace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1) + '>';
    }

    public static String generateHTML(String string) {
        return EndTagType.NORMAL.generateHTML(string);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this).append(' ');
        if (this.endTagType != EndTagType.NORMAL) {
            stringBuilder.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    static EndTag getPrevious(Source source2, int n, String string, EndTagType endTagType) {
        if (string == null) {
            return (EndTag)Tag.getPreviousTag(source2, n, endTagType);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        if (source2.wasFullSequentialParseCalled()) {
            EndTag endTag = (EndTag)Tag.getPreviousTag(source2, n, endTagType);
            while (true) {
                if (endTag == null) {
                    return null;
                }
                if (endTag.name.equals(string)) {
                    return endTag;
                }
                endTag = (EndTag)endTag.getPreviousTag(endTagType);
            }
        }
        String string2 = "</" + string;
        ParseText parseText = source2.getParseText();
        int n2 = n;
        do {
            if ((n2 = parseText.lastIndexOf(string2, n2)) == -1) {
                return null;
            }
            EndTag endTag = (EndTag)source2.getTagAt(n2);
            if (endTag == null || endTag.getEndTagType() != endTagType || !string.equals(endTag.getName())) continue;
            return endTag;
        } while (--n2 >= 0);
        return null;
    }

    static EndTag getNext(Source source2, int n, String string, EndTagType endTagType) {
        if (string == null) {
            return (EndTag)Tag.getNextTag(source2, n, endTagType);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        if (source2.wasFullSequentialParseCalled()) {
            EndTag endTag = (EndTag)Tag.getNextTag(source2, n, endTagType);
            while (true) {
                if (endTag == null) {
                    return null;
                }
                if (endTag.name.equals(string)) {
                    return endTag;
                }
                endTag = (EndTag)endTag.getNextTag(endTagType);
            }
        }
        String string2 = "</" + string;
        try {
            ParseText parseText = source2.getParseText();
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf(string2, n2)) == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source2.getTagAt(n2);
                if (endTag == null || endTag.getEndTagType() != endTagType || !string.equals(endTag.getName())) continue;
                return endTag;
            } while (++n2 < source2.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static EndTag getPrevious(Source source2, int n) {
        Tag tag = Tag.getPreviousTag(source2, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof EndTag) {
            return (EndTag)tag;
        }
        return tag.getPreviousEndTag();
    }

    static EndTag getNext(Source source2, int n) {
        Tag tag = Tag.getNextTag(source2, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof EndTag) {
            return (EndTag)tag;
        }
        return tag.getNextEndTag();
    }
}

