/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classloaderhandler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.ReflectionUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
class QuarkusClassLoaderHandler
implements ClassLoaderHandler {
    private static final String RUNTIME_CLASSLOADER = "io.quarkus.runner.RuntimeClassLoader";
    private static final String QUARKUS_CLASSLOADER = "io.quarkus.bootstrap.classloading.QuarkusClassLoader";
    private static final String RUNNER_CLASSLOADER = "io.quarkus.bootstrap.runner.RunnerClassLoader";

    private QuarkusClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return RUNTIME_CLASSLOADER.equals(classLoaderClass.getName()) || QUARKUS_CLASSLOADER.equals(classLoaderClass.getName()) || RUNNER_CLASSLOADER.equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        String classLoaderName = classLoader.getClass().getName();
        if (RUNTIME_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRuntimeClassloader(classLoader, classpathOrder, scanSpec, log);
        } else if (QUARKUS_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForQuarkusClassloader(classLoader, classpathOrder, scanSpec, log);
        } else if (RUNNER_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRunnerClassloader(classLoader, classpathOrder, scanSpec, log);
        }
    }

    private static void findClasspathOrderForQuarkusClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (Object element : (Collection)ReflectionUtils.getFieldVal(classLoader, "elements", false)) {
            String elementClassName = element.getClass().getName();
            if ("io.quarkus.bootstrap.classloading.JarClassPathElement".equals(elementClassName)) {
                classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "file", false), classLoader, scanSpec, log);
                continue;
            }
            if (!"io.quarkus.bootstrap.classloading.DirectoryClassPathElement".equals(elementClassName)) continue;
            classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "root", false), classLoader, scanSpec, log);
        }
    }

    private static void findClasspathOrderForRuntimeClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Collection applicationClassDirectories = (Collection)ReflectionUtils.getFieldVal(classLoader, "applicationClassDirectories", false);
        if (applicationClassDirectories != null) {
            for (Path path : applicationClassDirectories) {
                classpathOrder.addClasspathEntryObject(path.toUri(), classLoader, scanSpec, log);
            }
        }
    }

    private static void findClasspathOrderForRunnerClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Iterator iterator = ((Map)ReflectionUtils.getFieldVal(classLoader, "resourceDirectoryMap", false)).values().iterator();
        while (iterator.hasNext()) {
            Object[] elementArray;
            for (Object element : elementArray = (Object[])iterator.next()) {
                String elementClassName = element.getClass().getName();
                if (!"io.quarkus.bootstrap.runner.JarResource".equals(elementClassName)) continue;
                classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "jarPath", false), classLoader, scanSpec, log);
            }
        }
    }
}

