/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.Provider;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.StreamProvider;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.StringProvider;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.utils.Utils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class Providers {
    public static final Charset UTF8 = Charset.forName("utf-8");

    private Providers() {
    }

    public static Provider provider(Reader reader) {
        return new StreamProvider(Utils.assertNotNull(reader));
    }

    public static Provider provider(InputStream input2, Charset encoding) {
        Utils.assertNotNull(input2);
        Utils.assertNotNull(encoding);
        try {
            return new StreamProvider(input2, encoding.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Provider provider(InputStream input2) {
        return Providers.provider(input2, UTF8);
    }

    public static Provider provider(File file2, Charset encoding) throws FileNotFoundException {
        return Providers.provider(new FileInputStream(Utils.assertNotNull(file2)), Utils.assertNotNull(encoding));
    }

    public static Provider provider(File file2) throws FileNotFoundException {
        return Providers.provider(Utils.assertNotNull(file2), UTF8);
    }

    public static Provider provider(Path path, Charset encoding) throws IOException {
        return Providers.provider(Files.newInputStream(Utils.assertNotNull(path), new OpenOption[0]), Utils.assertNotNull(encoding));
    }

    public static Provider provider(Path path) throws IOException {
        return Providers.provider(Utils.assertNotNull(path), UTF8);
    }

    public static Provider provider(String source2) {
        return new StringProvider(Utils.assertNotNull(source2));
    }

    public static Provider resourceProvider(ClassLoader classLoader, String pathToResource, Charset encoding) throws IOException {
        InputStream resourceAsStream = classLoader.getResourceAsStream(pathToResource);
        if (resourceAsStream == null) {
            throw new IOException("Cannot find " + pathToResource);
        }
        return Providers.provider(resourceAsStream, encoding);
    }

    public static Provider resourceProvider(String pathToResource, Charset encoding) throws IOException {
        ClassLoader classLoader = Provider.class.getClassLoader();
        return Providers.resourceProvider(classLoader, pathToResource, encoding);
    }

    public static Provider resourceProvider(String pathToResource) throws IOException {
        return Providers.resourceProvider(pathToResource, UTF8);
    }
}

