/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.Position;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class Range {
    public final Position begin;
    public final Position end;

    public Range(Position begin2, Position end2) {
        if (begin2 == null) {
            throw new IllegalArgumentException("begin can't be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("end can't be null");
        }
        if (begin2.isBefore(end2)) {
            this.begin = begin2;
            this.end = end2;
        } else {
            this.begin = end2;
            this.end = begin2;
        }
    }

    public static Range range(Position begin2, Position end2) {
        return new Range(begin2, end2);
    }

    public static Range range(int beginLine, int beginColumn, int endLine, int endColumn) {
        return new Range(new Position(beginLine, beginColumn), new Position(endLine, endColumn));
    }

    public Range withBeginColumn(int beginColumn) {
        return Range.range(this.begin.withColumn(beginColumn), this.end);
    }

    public Range withBeginLine(int beginLine) {
        return Range.range(this.begin.withLine(beginLine), this.end);
    }

    public Range withEndColumn(int endColumn) {
        return Range.range(this.begin, this.end.withColumn(endColumn));
    }

    public Range withEndLine(int endLine) {
        return Range.range(this.begin, this.end.withLine(endLine));
    }

    public Range withBegin(Position begin2) {
        return Range.range(begin2, this.end);
    }

    public Range withEnd(Position end2) {
        return Range.range(this.begin, end2);
    }

    public boolean contains(Range other) {
        boolean beginResult = this.begin.isBeforeOrEqual(other.begin);
        if (!beginResult) {
            return false;
        }
        return this.end.isAfterOrEqual(other.end);
    }

    public boolean contains(Position position) {
        return this.strictlyContains(position) || this.begin.equals(position) || this.end.equals(position);
    }

    public boolean strictlyContains(Range other) {
        boolean beginResult = this.begin.isBefore(other.begin);
        boolean endResult = this.end.isAfter(other.end);
        return beginResult && endResult;
    }

    public boolean strictlyContains(Position position) {
        return position.isAfter(this.begin) && position.isBefore(this.end);
    }

    public boolean overlapsWith(Range other) {
        return this.contains(other.begin) || this.contains(other.end) || other.contains(this.begin) || other.contains(this.end);
    }

    public boolean isBefore(Position position) {
        return this.end.isBefore(position);
    }

    public boolean isBefore(Range other) {
        return this.end.isBefore(other.begin);
    }

    public boolean isAfter(Position position) {
        return this.begin.isAfter(position);
    }

    public boolean isAfter(Range other) {
        return this.begin.isAfter(other.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.begin.equals(range.begin) && this.end.equals(range.end);
    }

    public int hashCode() {
        return 31 * this.begin.hashCode() + this.end.hashCode();
    }

    public String toString() {
        return this.begin + "-" + this.end;
    }

    public int getLineCount() {
        return this.end.line - this.begin.line + 1;
    }
}

