/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.validator.language_level_validations.chunks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.Modifier;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.body.RecordDeclaration;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.validator.ProblemReporter;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.validator.TypedValidator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class RecordDeclarationValidator
implements TypedValidator<RecordDeclaration> {
    @Override
    public void accept(RecordDeclaration node, ProblemReporter reporter) {
        this.forbidAbstractModifier(node, reporter);
        this.forbidNonStaticFieldsInRecords(node, reporter);
        this.validateRecordComponentAccessorMethods(node, reporter);
    }

    private void forbidAbstractModifier(RecordDeclaration n, ProblemReporter reporter) {
        if (n.getModifiers().contains(Modifier.abstractModifier())) {
            reporter.report(n, "Record Declarations must not be declared as abstract.", new Object[0]);
        }
    }

    private void forbidNonStaticFieldsInRecords(RecordDeclaration n, ProblemReporter reporter) {
        long nonStaticFieldCount = n.getFields().stream().filter(fieldDeclaration -> !fieldDeclaration.isStatic()).count();
        if (nonStaticFieldCount > 0L) {
            reporter.report(n, "Record Declarations must have zero non-static fields.", new Object[0]);
        }
    }

    private void validateRecordComponentAccessorMethods(RecordDeclaration n, ProblemReporter reporter) {
        n.getParameters().forEach(parameter -> n.getMethodsByName(parameter.getNameAsString()).stream().filter(methodDeclaration -> methodDeclaration.getParameters().isEmpty()).forEach(methodDeclaration -> {
            if (!methodDeclaration.getType().equals(parameter.getType())) {
                reporter.report(n, String.format("Incorrect component accessor return type. Expected: '%s', found: '%s'.", parameter.getTypeAsString(), methodDeclaration.getTypeAsString()), new Object[0]);
            }
        }));
    }
}

