/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.base.Preconditions;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.ElementTypesAreNonnullByDefault;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Iterators;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Maps;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Multimap;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Multimaps;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Multiset;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.ParametricNullness;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.SetMultimap;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Sets;
import org.jetbrains.annotations.ApiStatus;

@ElementTypesAreNonnullByDefault
@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible
abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    @LazyInit
    @CheckForNull
    private transient Collection<Map.Entry<K, V>> entries;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySet;
    @LazyInit
    @CheckForNull
    private transient Multiset<K> keys;
    @LazyInit
    @CheckForNull
    private transient Collection<V> values;
    @LazyInit
    @CheckForNull
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        for (Collection<V> collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@CheckForNull Object key, @CheckForNull Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@CheckForNull Object key, @CheckForNull Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        return this.get(key).add(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get(key), valueItr);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        Collection result2 = this.removeAll(key);
        this.putAll(key, values);
        return result2;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result2 = this.entries;
        return result2 == null ? (this.entries = this.createEntries()) : result2;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), this instanceof SetMultimap ? 1 : 0);
    }

    @Override
    public Set<K> keySet() {
        Set<K> result2 = this.keySet;
        return result2 == null ? (this.keySet = this.createKeySet()) : result2;
    }

    abstract Set<K> createKeySet();

    @Override
    public Multiset<K> keys() {
        Multiset<K> result2 = this.keys;
        return result2 == null ? (this.keys = this.createKeys()) : result2;
    }

    abstract Multiset<K> createKeys();

    @Override
    public Collection<V> values() {
        Collection<V> result2 = this.values;
        return result2 == null ? (this.values = this.createValues()) : result2;
    }

    abstract Collection<V> createValues();

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), 0);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> result2 = this.asMap;
        return result2 == null ? (this.asMap = this.createAsMap()) : result2;
    }

    abstract Map<K, Collection<V>> createAsMap();

    @Override
    public boolean equals(@CheckForNull Object object) {
        return Multimaps.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return AbstractMultimap.this.valueIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            return AbstractMultimap.this.valueSpliterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.size();
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            return AbstractMultimap.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        EntrySet(AbstractMultimap this$0) {
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            return Sets.equalsImpl(this, obj);
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    class Entries
    extends Multimaps.Entries<K, V> {
        Entries() {
        }

        @Override
        Multimap<K, V> multimap() {
            return AbstractMultimap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.entryIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return AbstractMultimap.this.entrySpliterator();
        }
    }
}

