/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.resolution.logic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.resolution.MethodUsage;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.resolution.types.ResolvedType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class FunctionalInterfaceLogic {
    private static String JAVA_LANG_FUNCTIONAL_INTERFACE = FunctionalInterface.class.getCanonicalName();
    private static List<String> OBJECT_PUBLIC_METHODS_SIGNATURES = Arrays.stream(Object.class.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).map(method -> FunctionalInterfaceLogic.getSignature(method)).collect(Collectors.toList());

    private FunctionalInterfaceLogic() {
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration();
        if (!optionalTypeDeclaration.isPresent()) {
            return Optional.empty();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = optionalTypeDeclaration.get();
        if (type.isReferenceType() && typeDeclaration.isInterface()) {
            return FunctionalInterfaceLogic.getFunctionalMethod(typeDeclaration);
        }
        return Optional.empty();
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedReferenceTypeDeclaration typeDeclaration) {
        Set methods = typeDeclaration.getAllMethods().stream().filter(m -> m.getDeclaration().isAbstract()).filter(m -> !FunctionalInterfaceLogic.isPublicMemberOfObject(m)).collect(Collectors.toSet());
        if (methods.size() == 0) {
            return Optional.empty();
        }
        Iterator iterator = methods.iterator();
        MethodUsage methodUsage = (MethodUsage)iterator.next();
        while (iterator.hasNext()) {
            MethodUsage otherMethodUsage = (MethodUsage)iterator.next();
            if (!(methodUsage.isSameSignature(otherMethodUsage) || methodUsage.isSubSignature(otherMethodUsage) || otherMethodUsage.isSubSignature(methodUsage))) {
                methodUsage = null;
                break;
            }
            if (methodUsage.isReturnTypeSubstituable(otherMethodUsage)) continue;
            methodUsage = null;
            break;
        }
        return Optional.ofNullable(methodUsage);
    }

    public static boolean isFunctionalInterfaceType(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration;
        if (type.isReferenceType() && (optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration()).isPresent() && optionalTypeDeclaration.get().hasAnnotation(JAVA_LANG_FUNCTIONAL_INTERFACE)) {
            return true;
        }
        return FunctionalInterfaceLogic.getFunctionalMethod(type).isPresent();
    }

    private static String getSignature(Method m) {
        return String.format("%s(%s)", m.getName(), String.join((CharSequence)", ", Arrays.stream(m.getParameters()).map(p2 -> FunctionalInterfaceLogic.toSignature(p2)).collect(Collectors.toList())));
    }

    private static String toSignature(Parameter p2) {
        return p2.getType().getCanonicalName();
    }

    private static boolean isPublicMemberOfObject(MethodUsage m) {
        return OBJECT_PUBLIC_METHODS_SIGNATURES.contains(m.getDeclaration().getSignature());
    }
}

