/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.util.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.ImmutableCollection;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect.Lists;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.util.concurrent.AggregateFuture;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.util.concurrent.ListenableFuture;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.util.concurrent.ParametricNullness;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ElementTypesAreNonnullByDefault
@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    @CheckForNull
    private List<@Nullable Present<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        List<@Nullable T> values = futures.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity(futures.size());
        for (int i2 = 0; i2 < futures.size(); ++i2) {
            values.add(null);
        }
        this.values = values;
    }

    @Override
    final void collectOneValue(int index, @ParametricNullness V returnValue) {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, new Present<V>(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<@Nullable Present<V>> var1);

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class Present<V> {
        V value;

        Present(V value) {
            this.value = value;
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<@Nullable V> combine(List<@Nullable Present<V>> values) {
            ArrayList<@Nullable Object> result2 = Lists.newArrayListWithCapacity(values.size());
            for (Present<V> element : values) {
                result2.add(element != null ? (Object)element.value : null);
            }
            return Collections.unmodifiableList(result2);
        }
    }
}

