/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.LoggerQueue;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StreamEncodingDetector;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
final class EncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private final String preliminaryEncoding;
    private final Integer preliminaryEncodingCodeUnitSize;
    private final String preliminaryEncodingSpecificationInfo;
    private final String alternativePreliminaryEncoding;
    private LoggerQueue logger = new LoggerQueue();
    private static final int PREVIEW_BYTE_COUNT = 2048;
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";

    public EncodingDetector(URLConnection uRLConnection) throws IOException {
        this(new StreamEncodingDetector(uRLConnection));
    }

    public EncodingDetector(InputStream inputStream) throws IOException {
        this(new StreamEncodingDetector(inputStream));
    }

    public EncodingDetector(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, "preliminary encoding set explicitly", null);
        this.logger = new LoggerQueue();
        if (!EncodingDetector.isEncodingSupported(string)) {
            throw new UnsupportedEncodingException(string + " specified as preliminaryEncoding constructor argument");
        }
        this.detectDocumentSpecifiedEncoding();
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector) throws IOException {
        this(streamEncodingDetector, ISO_8859_1);
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector, String string) throws IOException {
        this(streamEncodingDetector.getInputStream(), streamEncodingDetector.getEncoding(), streamEncodingDetector.getEncodingSpecificationInfo(), string);
        this.logger = streamEncodingDetector.getLoggerQueue();
        if (streamEncodingDetector.isDifinitive() || !streamEncodingDetector.isDocumentSpecifiedEncodingPossible()) {
            this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo);
        } else {
            this.detectDocumentSpecifiedEncoding();
        }
    }

    private EncodingDetector(InputStream inputStream, String string, String string2, String string3) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.preliminaryEncoding = string;
        this.preliminaryEncodingCodeUnitSize = StreamEncodingDetector.codeUnitSizeMap.get(string == null ? null : string.toUpperCase());
        this.preliminaryEncodingSpecificationInfo = string2;
        this.alternativePreliminaryEncoding = string3;
        if (string3 != null && !EncodingDetector.isEncodingSupported(string3)) {
            throw new UnsupportedEncodingException(string3 + " specified as alternativePreliminaryEncoding constructor argument");
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncoding() {
        return this.preliminaryEncoding;
    }

    public String getPreliminaryEncodingSpecificationInfo() {
        return this.preliminaryEncodingSpecificationInfo;
    }

    public LoggerQueue getLoggerQueue() {
        return this.logger;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!EncodingDetector.isEncodingSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + ": " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String string, String string2) {
        this.encoding = string;
        this.encodingSpecificationInfo = string2;
        return true;
    }

    private boolean detectDocumentSpecifiedEncoding() throws IOException {
        String string;
        String string2;
        block12: {
            String string3;
            this.inputStream.mark(2048);
            if (EncodingDetector.isEncodingSupported(this.preliminaryEncoding)) {
                string2 = this.preliminaryEncoding;
            } else {
                if (this.alternativePreliminaryEncoding == null) {
                    throw new UnsupportedEncodingException(this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
                }
                string2 = this.alternativePreliminaryEncoding;
            }
            Source source2 = this.getPreviewSource(string2);
            this.inputStream.reset();
            source2.setLogger(null);
            if (this.preliminaryEncoding != string2 && this.logger.isWarnEnabled()) {
                this.logger.warn("Alternative encoding " + string2 + " substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
            }
            if ((string3 = source2.getDocumentSpecifiedEncoding(this)) == null) {
                if (source2.isXML()) {
                    return this.setEncoding(UTF_8, "mandatory XML encoding when no BOM or encoding declaration is present");
                }
                string = "no encoding specified in document";
            } else {
                try {
                    if (EncodingDetector.isEncodingSupported(string3)) {
                        return this.setEncoding(string3, source2.getEncodingSpecificationInfo());
                    }
                    string = "encoding " + string3 + " specified in document is not supported";
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Unsupported encoding " + string3 + " specified in document, using preliminary encoding " + string2 + " instead");
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    string = "illegal encoding " + string3 + " specified in document";
                    if (!this.logger.isWarnEnabled()) break block12;
                    this.logger.warn("Illegal encoding " + string3 + " specified in document, using preliminary encoding " + string2 + " instead");
                }
            }
        }
        if (this.preliminaryEncoding != string2) {
            return this.setEncoding(string2, "alternative encoding substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo + ", " + string);
        }
        return this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo + ", " + string);
    }

    boolean isIncompatibleWithPreliminaryEncoding(String string) {
        if (this.preliminaryEncodingCodeUnitSize == null || string == null) {
            return false;
        }
        Integer n = StreamEncodingDetector.codeUnitSizeMap.get(string.toUpperCase());
        if (n == null) {
            return false;
        }
        return !this.preliminaryEncodingCodeUnitSize.equals(n);
    }

    private Source getPreviewSource(String string) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[2048];
        for (n2 = 0; n2 < 2048 && (n = this.inputStream.read()) != -1; ++n2) {
            byArray[n2] = (byte)n;
        }
        return new Source(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), string), null);
    }

    static boolean isEncodingSupported(String string) {
        try {
            return Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }
}

