/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.safety;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.helper.Validate;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Attribute;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Attributes;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.DataNode;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Document;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Node;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.TextNode;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.parser.ParseErrorList;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.parser.Parser;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.parser.Tag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.safety.Safelist;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.select.NodeTraversor;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.select.NodeVisitor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class Cleaner {
    private final Safelist safelist;

    public Cleaner(Safelist safelist) {
        Validate.notNull(safelist);
        this.safelist = safelist;
    }

    public Document clean(Document dirtyDocument) {
        Validate.notNull(dirtyDocument);
        Document clean = Document.createShell(dirtyDocument.baseUri());
        this.copySafeNodes(dirtyDocument.body(), clean.body());
        clean.outputSettings(dirtyDocument.outputSettings().clone());
        return clean;
    }

    public boolean isValid(Document dirtyDocument) {
        Validate.notNull(dirtyDocument);
        Document clean = Document.createShell(dirtyDocument.baseUri());
        int numDiscarded = this.copySafeNodes(dirtyDocument.body(), clean.body());
        return numDiscarded == 0 && dirtyDocument.head().childNodes().isEmpty();
    }

    public boolean isValidBodyHtml(String bodyHtml) {
        Document clean = Document.createShell("");
        Document dirty = Document.createShell("");
        ParseErrorList errorList = ParseErrorList.tracking(1);
        List<Node> nodes = Parser.parseFragment(bodyHtml, dirty.body(), "", errorList);
        dirty.body().insertChildren(0, nodes);
        int numDiscarded = this.copySafeNodes(dirty.body(), clean.body());
        return numDiscarded == 0 && errorList.isEmpty();
    }

    private int copySafeNodes(Element source2, Element dest) {
        CleaningVisitor cleaningVisitor = new CleaningVisitor(source2, dest);
        NodeTraversor.traverse((NodeVisitor)cleaningVisitor, source2);
        return cleaningVisitor.numDiscarded;
    }

    private ElementMeta createSafeElement(Element sourceEl) {
        String sourceTag = sourceEl.tagName();
        Attributes destAttrs = new Attributes();
        Element dest = new Element(Tag.valueOf(sourceTag), sourceEl.baseUri(), destAttrs);
        int numDiscarded = 0;
        Attributes sourceAttrs = sourceEl.attributes();
        for (Attribute sourceAttr : sourceAttrs) {
            if (this.safelist.isSafeAttribute(sourceTag, sourceEl, sourceAttr)) {
                destAttrs.put(sourceAttr);
                continue;
            }
            ++numDiscarded;
        }
        Attributes enforcedAttrs = this.safelist.getEnforcedAttributes(sourceTag);
        destAttrs.addAll(enforcedAttrs);
        if (sourceEl.sourceRange().isTracked()) {
            sourceEl.sourceRange().track(dest, true);
        }
        if (sourceEl.endSourceRange().isTracked()) {
            sourceEl.endSourceRange().track(dest, false);
        }
        return new ElementMeta(dest, numDiscarded);
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static class ElementMeta {
        Element el;
        int numAttribsDiscarded;

        ElementMeta(Element el, int numAttribsDiscarded) {
            this.el = el;
            this.numAttribsDiscarded = numAttribsDiscarded;
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private final class CleaningVisitor
    implements NodeVisitor {
        private int numDiscarded = 0;
        private final Element root;
        private Element destination;

        private CleaningVisitor(Element root, Element destination) {
            this.root = root;
            this.destination = destination;
        }

        @Override
        public void head(Node source2, int depth) {
            if (source2 instanceof Element) {
                Element sourceEl = (Element)source2;
                if (Cleaner.this.safelist.isSafeTag(sourceEl.normalName())) {
                    ElementMeta meta2 = Cleaner.this.createSafeElement(sourceEl);
                    Element destChild = meta2.el;
                    this.destination.appendChild(destChild);
                    this.numDiscarded += meta2.numAttribsDiscarded;
                    this.destination = destChild;
                } else if (source2 != this.root) {
                    ++this.numDiscarded;
                }
            } else if (source2 instanceof TextNode) {
                TextNode sourceText = (TextNode)source2;
                TextNode destText = new TextNode(sourceText.getWholeText());
                this.destination.appendChild(destText);
            } else if (source2 instanceof DataNode && Cleaner.this.safelist.isSafeTag(source2.parent().nodeName())) {
                DataNode sourceData = (DataNode)source2;
                DataNode destData = new DataNode(sourceData.getWholeData());
                this.destination.appendChild(destData);
            } else {
                ++this.numDiscarded;
            }
        }

        @Override
        public void tail(Node source2, int depth) {
            if (source2 instanceof Element && Cleaner.this.safelist.isSafeTag(source2.nodeName())) {
                this.destination = this.destination.parent();
            }
        }
    }
}

