/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassRefOrTypeVariableSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.TypeArgument;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.TypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.TypeVariableSignature;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.types.ParseException;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.types.Parser;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.types.TypeUtils;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class ClassRefTypeSignature
extends ClassRefOrTypeVariableSignature {
    final String className;
    private String fullyQualifiedClassName;
    private final List<TypeArgument> typeArguments;
    private final List<String> suffixes;
    private final List<List<TypeArgument>> suffixTypeArguments;

    private ClassRefTypeSignature(String className, List<TypeArgument> typeArguments, List<String> suffixes, List<List<TypeArgument>> suffixTypeArguments) {
        this.className = className;
        this.typeArguments = typeArguments;
        this.suffixes = suffixes;
        this.suffixTypeArguments = suffixTypeArguments;
    }

    public String getBaseClassName() {
        return this.className;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClassName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            for (String suffix : this.suffixes) {
                buf.append('$');
                buf.append(suffix);
            }
            this.fullyQualifiedClassName = buf.toString();
        }
        return this.fullyQualifiedClassName;
    }

    public List<TypeArgument> getTypeArguments() {
        return this.typeArguments;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public List<List<TypeArgument>> getSuffixTypeArguments() {
        return this.suffixTypeArguments;
    }

    @Override
    public Class<?> loadClass(boolean ignoreExceptions) {
        return super.loadClass(ignoreExceptions);
    }

    @Override
    public Class<?> loadClass() {
        return super.loadClass();
    }

    @Override
    protected String getClassName() {
        return this.getFullyQualifiedClassName();
    }

    @Override
    public ClassInfo getClassInfo() {
        return super.getClassInfo();
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeArguments != null) {
            for (TypeArgument typeArgument : this.typeArguments) {
                typeArgument.setScanResult(scanResult);
            }
        }
        if (this.suffixTypeArguments != null) {
            for (List list : this.suffixTypeArguments) {
                for (TypeArgument typeArgument : list) {
                    typeArgument.setScanResult(scanResult);
                }
            }
        }
    }

    @Override
    protected void findReferencedClassNames(Set<String> refdClassNames) {
        refdClassNames.add(this.getFullyQualifiedClassName());
        for (TypeArgument typeArgument : this.typeArguments) {
            typeArgument.findReferencedClassNames(refdClassNames);
        }
    }

    public int hashCode() {
        return this.className.hashCode() + 7 * this.typeArguments.hashCode() + 15 * this.suffixes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassRefTypeSignature)) {
            return false;
        }
        ClassRefTypeSignature o = (ClassRefTypeSignature)obj;
        return o.className.equals(this.className) && o.typeArguments.equals(this.typeArguments) && o.suffixes.equals(this.suffixes);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (other instanceof TypeVariableSignature) {
            return other.equalsIgnoringTypeParams(this);
        }
        if (!(other instanceof ClassRefTypeSignature)) {
            return false;
        }
        ClassRefTypeSignature o = (ClassRefTypeSignature)other;
        if (o.suffixes.equals(this.suffixes)) {
            return o.className.equals(this.className);
        }
        return o.getFullyQualifiedClassName().equals(this.getFullyQualifiedClassName());
    }

    @Override
    protected String toStringInternal(boolean useSimpleNames) {
        int i2;
        StringBuilder buf = new StringBuilder();
        if (!useSimpleNames || this.suffixes.isEmpty()) {
            buf.append(useSimpleNames ? ClassInfo.getSimpleName(this.className) : this.className);
            if (!this.typeArguments.isEmpty()) {
                buf.append('<');
                for (i2 = 0; i2 < this.typeArguments.size(); ++i2) {
                    if (i2 > 0) {
                        buf.append(", ");
                    }
                    buf.append(useSimpleNames ? this.typeArguments.get(i2).toStringWithSimpleNames() : this.typeArguments.get(i2).toString());
                }
                buf.append('>');
            }
        }
        int n = i2 = useSimpleNames && !this.suffixes.isEmpty() ? this.suffixes.size() - 1 : 0;
        while (i2 < this.suffixes.size()) {
            if (!useSimpleNames) {
                buf.append('.');
            }
            buf.append(this.suffixes.get(i2));
            List<TypeArgument> suffixTypeArgs = this.suffixTypeArguments.get(i2);
            if (!suffixTypeArgs.isEmpty()) {
                buf.append('<');
                for (int j = 0; j < suffixTypeArgs.size(); ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(useSimpleNames ? suffixTypeArgs.get(j).toStringWithSimpleNames() : suffixTypeArgs.get(j).toString());
                }
                buf.append('>');
            }
            ++i2;
        }
        return buf.toString();
    }

    static ClassRefTypeSignature parse(Parser parser, String definingClassName) throws ParseException {
        if (parser.peek() == 'L') {
            List<List<TypeArgument>> suffixTypeArguments;
            List<String> suffixes;
            parser.next();
            if (!TypeUtils.getIdentifierToken(parser, '/', '.')) {
                throw new ParseException(parser, "Could not parse identifier token");
            }
            String className = parser.currToken();
            List<TypeArgument> typeArguments = TypeArgument.parseList(parser, definingClassName);
            if (parser.peek() == '.') {
                suffixes = new ArrayList();
                suffixTypeArguments = new ArrayList();
                while (parser.peek() == '.') {
                    parser.expect('.');
                    if (!TypeUtils.getIdentifierToken(parser, '/', '.')) {
                        throw new ParseException(parser, "Could not parse identifier token");
                    }
                    suffixes.add(parser.currToken());
                    suffixTypeArguments.add(TypeArgument.parseList(parser, definingClassName));
                }
            } else {
                suffixes = Collections.emptyList();
                suffixTypeArguments = Collections.emptyList();
            }
            parser.expect(';');
            return new ClassRefTypeSignature(className, typeArguments, suffixes, suffixTypeArguments);
        }
        return null;
    }
}

