/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.check_updates;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import name.remal.gradle_plugins.dsl.BuildTask;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_TaskKt;
import name.remal.gradle_plugins.integrations.gradle_org.GradleOrgClient;
import name.remal.gradle_plugins.integrations.gradle_org.VersionInfo;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;

@BuildTask
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0015\u00a8\u0006\u0005"}, d2={"Lname/remal/gradle_plugins/plugins/check_updates/CheckGradleUpdates;", "Lorg/gradle/api/DefaultTask;", "()V", "doCheckGradleUpdates", "", "gradle-plugins"})
public class CheckGradleUpdates
extends DefaultTask {
    @TaskAction
    protected void doCheckGradleUpdates() {
        try {
            GradleVersion currentVersion = GradleVersion.current();
            Logger logger = this.getLogger();
            GradleVersion gradleVersion = currentVersion;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"currentVersion");
            logger.info("Current Gradle version: {}", (Object)gradleVersion.getVersion());
            VersionInfo info = GradleOrgClient.INSTANCE.getCurrentVersion();
            this.getLogger().info("Latest Gradle version: {}", (Object)info.getVersion());
            if (currentVersion.compareTo(GradleVersion.version((String)info.getVersion())) < 0) {
                this.getLogger().lifecycle("New Gradle version is available: {} (downloadUrl: {})", new Object[]{info.getVersion(), info.getDownloadUrl()});
            }
            this.setDidWork(true);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public CheckGradleUpdates() {
        this.setGroup("help");
        this.setDescription("Displays a message if there is newer version of Gradle");
        this.onlyIf(1.INSTANCE);
        Org_gradle_api_TaskKt.skipIfOffline((Task)this);
    }
}

