/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassGraphException;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.HierarchicalTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ReferenceTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.types.ParseException;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.types.Parser;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class TypeArgument
extends HierarchicalTypeSignature {
    private final Wildcard wildcard;
    private final ReferenceTypeSignature typeSignature;

    private TypeArgument(Wildcard wildcard, ReferenceTypeSignature typeSignature) {
        this.wildcard = wildcard;
        this.typeSignature = typeSignature;
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    public ReferenceTypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    private static TypeArgument parse(Parser parser, String definingClassName) throws ParseException {
        char peek = parser.peek();
        if (peek == '*') {
            parser.expect('*');
            return new TypeArgument(Wildcard.ANY, null);
        }
        if (peek == '+') {
            parser.expect('+');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
            if (typeSignature == null) {
                throw new ParseException(parser, "Missing '+' type bound");
            }
            return new TypeArgument(Wildcard.EXTENDS, typeSignature);
        }
        if (peek == '-') {
            parser.expect('-');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
            if (typeSignature == null) {
                throw new ParseException(parser, "Missing '-' type bound");
            }
            return new TypeArgument(Wildcard.SUPER, typeSignature);
        }
        ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
        if (typeSignature == null) {
            throw new ParseException(parser, "Missing type bound");
        }
        return new TypeArgument(Wildcard.NONE, typeSignature);
    }

    static List<TypeArgument> parseList(Parser parser, String definingClassName) throws ParseException {
        if (parser.peek() == '<') {
            parser.expect('<');
            ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>(2);
            while (parser.peek() != '>') {
                if (!parser.hasMore()) {
                    throw new ParseException(parser, "Missing '>'");
                }
                typeArguments.add(TypeArgument.parse(parser, definingClassName));
            }
            parser.expect('>');
            return typeArguments;
        }
        return Collections.emptyList();
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
    }

    public void findReferencedClassNames(Set<String> refdClassNames) {
        if (this.typeSignature != null) {
            this.typeSignature.findReferencedClassNames(refdClassNames);
        }
    }

    public int hashCode() {
        return this.typeSignature.hashCode() + 7 * this.wildcard.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeArgument)) {
            return false;
        }
        TypeArgument o = (TypeArgument)obj;
        return o.typeSignature.equals(this.typeSignature) && o.wildcard.equals((Object)this.wildcard);
    }

    private String toStringInternal(boolean useSimpleNames) {
        switch (this.wildcard) {
            case ANY: {
                return "?";
            }
            case EXTENDS: {
                String typeSigStr = this.typeSignature.toString();
                return typeSigStr.equals("java.lang.Object") ? "?" : "? extends " + typeSigStr;
            }
            case SUPER: {
                return "? super " + this.typeSignature.toString();
            }
            case NONE: {
                return useSimpleNames ? this.typeSignature.toStringWithSimpleNames() : this.typeSignature.toString();
            }
        }
        throw ClassGraphException.newClassGraphException("Unknown wildcard type " + (Object)((Object)this.wildcard));
    }

    public String toStringWithSimpleNames() {
        return this.toStringInternal(true);
    }

    public String toString() {
        return this.toStringInternal(false);
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    public static enum Wildcard {
        NONE,
        ANY,
        EXTENDS,
        SUPER;

    }
}

