/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CallAdapter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CompletableFutureCallAdapterFactory;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.DefaultCallAdapterFactory;
import name.remal.gradle_plugins.internal._relocated.retrofit2.OptionalConverterFactory;

@RelocatedClass
@Generated
@SuppressFBWarnings
class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    private final boolean hasJava8Types;
    @Nullable
    private final Constructor<MethodHandles.Lookup> lookupConstructor;

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Platform(true);
    }

    Platform(boolean hasJava8Types) {
        this.hasJava8Types = hasJava8Types;
        Constructor lookupConstructor = null;
        if (hasJava8Types) {
            try {
                lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookupConstructor.setAccessible(true);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.lookupConstructor = lookupConstructor;
    }

    @Nullable
    Executor defaultCallbackExecutor() {
        return null;
    }

    List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
        DefaultCallAdapterFactory executorFactory = new DefaultCallAdapterFactory(callbackExecutor);
        return this.hasJava8Types ? Arrays.asList(CompletableFutureCallAdapterFactory.INSTANCE, executorFactory) : Collections.singletonList(executorFactory);
    }

    int defaultCallAdapterFactoriesSize() {
        return this.hasJava8Types ? 2 : 1;
    }

    List<? extends Converter.Factory> defaultConverterFactories() {
        return this.hasJava8Types ? Collections.singletonList(OptionalConverterFactory.INSTANCE) : Collections.emptyList();
    }

    int defaultConverterFactoriesSize() {
        return this.hasJava8Types ? 1 : 0;
    }

    boolean isDefaultMethod(Method method) {
        return this.hasJava8Types && method.isDefault();
    }

    @Nullable
    Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
        MethodHandles.Lookup lookup = this.lookupConstructor != null ? this.lookupConstructor.newInstance(declaringClass, -1) : MethodHandles.lookup();
        return lookup.unreflectSpecial(method, declaringClass).bindTo(object).invokeWithArguments(args);
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class Android
    extends Platform {
        Android() {
            super(Build.VERSION.SDK_INT >= 24);
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        @Nullable
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
            if (Build.VERSION.SDK_INT < 26) {
                throw new UnsupportedOperationException("Calling default methods on API 24 and 25 is not supported");
            }
            return super.invokeDefaultMethod(method, declaringClass, object, args);
        }

        @RelocatedClass
        @Generated
        @SuppressFBWarnings
        static final class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                this.handler.post(r);
            }
        }
    }
}

