/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.internal.modules;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import name.remal.gradle_plugins.api.AutoService;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.DeserializationContext;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.Module;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.module.SimpleModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RelocatedClass
@Generated
@SuppressFBWarnings
@AutoService(value={Module.class})
public class DateTimeFormatsModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    @Override
    public void setupModule(@NotNull Module.SetupContext context) {
        super.setupModule(context);
        context.addDeserializationProblemHandler(new DateTimeFormatsDeserializationProblemHandler());
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    public static class DateTimeFormatsDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private static final long NANOS_PER_SECOND = 1000000000L;
        @NotNull
        private static final SortedMap<String, Duration> DURATION_SUFFIXES;
        private static final long SECONDS_PER_YEAR;
        private static final long SECONDS_PER_MONTH;
        private static final long SECONDS_PER_DAY = 86400L;
        @NotNull
        private static final List<DateTimeFormatter> ZONED_DATE_TIME_FORMATTERS;
        @NotNull
        private static final List<DateTimeFormatter> LOCAL_DATE_TIME_FORMATTERS;
        @NotNull
        private static final List<DateTimeFormatter> OFFSET_TIME_FORMATTERS;
        @NotNull
        private static final List<DateTimeFormatter> LOCAL_DATE_FORMATTERS;
        @NotNull
        private static final List<DateTimeFormatter> LOCAL_TIME_FORMATTERS;

        @Override
        public Object handleWeirdKey(@NotNull DeserializationContext ctxt, @NotNull Class<?> rawKeyType, @NotNull String keyValue, @NotNull String failureMsg) {
            return this.handleWeirdString(ctxt, rawKeyType, keyValue);
        }

        @Override
        public Object handleWeirdStringValue(@NotNull DeserializationContext ctxt, @NotNull Class<?> targetType, @NotNull String valueToConvert, @NotNull String failureMsg) {
            return this.handleWeirdString(ctxt, targetType, valueToConvert);
        }

        @Nullable
        private static Duration parseDuration(@NotNull String value) {
            value = value.toLowerCase();
            for (Map.Entry<String, Duration> entry : DURATION_SUFFIXES.entrySet()) {
                String suffix = entry.getKey();
                Duration suffixDuration = entry.getValue();
                if (!value.endsWith(suffix)) continue;
                value = value.substring(0, value.length() - suffix.length()).trim();
                try {
                    long longNanos;
                    long longSeconds;
                    if (!value.contains(".")) {
                        long amount = Long.parseLong(value);
                        if (amount == 1L) {
                            return suffixDuration;
                        }
                        return Duration.ofSeconds(amount * suffixDuration.getSeconds(), amount * (long)suffixDuration.getNano());
                    }
                    double amount = Double.parseDouble(value);
                    if (amount >= 0.0) {
                        double seconds = amount * (double)suffixDuration.getSeconds();
                        longSeconds = Math.round(Math.floor(seconds));
                        double nanos = amount * (double)suffixDuration.getNano() + (seconds - (double)longSeconds) * 1.0E9;
                        longNanos = Math.round(Math.floor(nanos));
                    } else {
                        double seconds = amount * (double)suffixDuration.getSeconds();
                        longSeconds = -Math.round(Math.ceil(seconds));
                        double nanos = amount * (double)suffixDuration.getNano() + (seconds - (double)longSeconds) * 1.0E9;
                        longNanos = Math.round(Math.ceil(nanos));
                    }
                    return Duration.ofSeconds(longSeconds, longNanos);
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            return null;
        }

        @Nullable
        private Object handleWeirdString(@NotNull DeserializationContext ctxt, @NotNull Class<?> targetType, @Nullable String value) {
            if (value == null) {
                return NOT_HANDLED;
            }
            if ((value = value.trim()).isEmpty()) {
                return NOT_HANDLED;
            }
            if (Duration.class.isAssignableFrom(targetType)) {
                Duration duration = DateTimeFormatsDeserializationProblemHandler.parseDuration(value);
                if (duration != null) {
                    return duration;
                }
            } else if (Period.class.isAssignableFrom(targetType)) {
                Duration duration = DateTimeFormatsDeserializationProblemHandler.parseDuration(value);
                if (duration == null) {
                    return NOT_HANDLED;
                }
                try {
                    long seconds = duration.getSeconds();
                    long years = seconds / SECONDS_PER_YEAR;
                    long months = (seconds -= years * SECONDS_PER_YEAR) / SECONDS_PER_MONTH;
                    long days = (seconds -= months * SECONDS_PER_MONTH) / 86400L;
                    return Period.of(Math.toIntExact(years), Math.toIntExact(months), Math.toIntExact(days));
                }
                catch (Exception ignored) {
                    return NOT_HANDLED;
                }
            }
            ChronoZonedDateTime zonedDateTime = null;
            for (DateTimeFormatter formatter : ZONED_DATE_TIME_FORMATTERS) {
                try {
                    zonedDateTime = ZonedDateTime.from(formatter.parse(value));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (zonedDateTime != null) {
                if (LocalDateTime.class.isAssignableFrom(targetType)) {
                    return LocalDateTime.ofInstant(zonedDateTime.toInstant(), ctxt.getTimeZone().toZoneId());
                }
                if (LocalDate.class.isAssignableFrom(targetType)) {
                    return LocalDateTime.ofInstant(zonedDateTime.toInstant(), ctxt.getTimeZone().toZoneId()).toLocalDate();
                }
                if (LocalTime.class.isAssignableFrom(targetType)) {
                    return LocalDateTime.ofInstant(zonedDateTime.toInstant(), ctxt.getTimeZone().toZoneId()).toLocalTime();
                }
                if (OffsetDateTime.class.isAssignableFrom(targetType)) {
                    return ((ZonedDateTime)zonedDateTime).toOffsetDateTime();
                }
                if (OffsetTime.class.isAssignableFrom(targetType)) {
                    return ((ZonedDateTime)zonedDateTime).toOffsetDateTime().toOffsetTime();
                }
                if (ZonedDateTime.class.isAssignableFrom(targetType)) {
                    return zonedDateTime;
                }
            }
            LocalDateTime localDateTime = null;
            for (DateTimeFormatter formatter : LOCAL_DATE_TIME_FORMATTERS) {
                try {
                    localDateTime = LocalDateTime.from(formatter.parse(value));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (localDateTime != null) {
                if (LocalDateTime.class.isAssignableFrom(targetType)) {
                    return localDateTime;
                }
                if (LocalDate.class.isAssignableFrom(targetType)) {
                    return localDateTime.toLocalDate();
                }
                if (LocalTime.class.isAssignableFrom(targetType)) {
                    return localDateTime.toLocalTime();
                }
                if (OffsetDateTime.class.isAssignableFrom(targetType)) {
                    return OffsetDateTime.of(localDateTime, ctxt.getTimeZone().toZoneId().getRules().getOffset(Instant.now()));
                }
                if (OffsetTime.class.isAssignableFrom(targetType)) {
                    return OffsetDateTime.of(localDateTime, ctxt.getTimeZone().toZoneId().getRules().getOffset(Instant.now())).toOffsetTime();
                }
                if (ZonedDateTime.class.isAssignableFrom(targetType)) {
                    return ZonedDateTime.of(localDateTime, ctxt.getTimeZone().toZoneId());
                }
            }
            OffsetTime offsetTime = null;
            for (DateTimeFormatter formatter : OFFSET_TIME_FORMATTERS) {
                try {
                    offsetTime = OffsetTime.from(formatter.parse(value));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (offsetTime != null) {
                if (LocalTime.class.isAssignableFrom(targetType)) {
                    int offsetSeconds = ctxt.getTimeZone().toZoneId().getRules().getOffset(Instant.now()).getTotalSeconds();
                    return offsetTime.toLocalTime().plus(offsetSeconds -= offsetTime.getOffset().getTotalSeconds(), ChronoUnit.SECONDS);
                }
                if (OffsetTime.class.isAssignableFrom(targetType)) {
                    return offsetTime;
                }
            }
            LocalDate localDate = null;
            for (DateTimeFormatter formatter : LOCAL_DATE_FORMATTERS) {
                try {
                    localDate = LocalDate.from(formatter.parse(value));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (localDate != null && LocalDate.class.isAssignableFrom(targetType)) {
                return localDate;
            }
            LocalTime localTime = null;
            for (DateTimeFormatter formatter : LOCAL_TIME_FORMATTERS) {
                try {
                    localTime = LocalTime.from(formatter.parse(value));
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (localTime != null) {
                if (LocalTime.class.isAssignableFrom(targetType)) {
                    return localTime;
                }
                if (OffsetTime.class.isAssignableFrom(targetType)) {
                    return OffsetTime.of(localTime, ctxt.getTimeZone().toZoneId().getRules().getOffset(Instant.now()));
                }
            }
            return NOT_HANDLED;
        }

        static {
            TreeMap<String, Duration> durationSuffixes = new TreeMap<String, Duration>((s1, s2) -> {
                int result2 = Integer.compare(s1.length(), s2.length());
                if (result2 == 0) {
                    result2 = s1.compareTo((String)s2);
                }
                return -1 * result2;
            });
            durationSuffixes.put("ns", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nano", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nanos", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nanosec", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nanosecs", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nanosecond", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("nanoseconds", ChronoUnit.NANOS.getDuration());
            durationSuffixes.put("us", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("micro", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("micros", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("microsec", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("microsecs", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("microsecond", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("microseconds", ChronoUnit.MICROS.getDuration());
            durationSuffixes.put("ms", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("milli", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("millis", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("millisec", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("millisecs", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("millisecond", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("milliseconds", ChronoUnit.MILLIS.getDuration());
            durationSuffixes.put("s", ChronoUnit.SECONDS.getDuration());
            durationSuffixes.put("sec", ChronoUnit.SECONDS.getDuration());
            durationSuffixes.put("secs", ChronoUnit.SECONDS.getDuration());
            durationSuffixes.put("second", ChronoUnit.SECONDS.getDuration());
            durationSuffixes.put("seconds", ChronoUnit.SECONDS.getDuration());
            durationSuffixes.put("m", ChronoUnit.MINUTES.getDuration());
            durationSuffixes.put("min", ChronoUnit.MINUTES.getDuration());
            durationSuffixes.put("mins", ChronoUnit.MINUTES.getDuration());
            durationSuffixes.put("minute", ChronoUnit.MINUTES.getDuration());
            durationSuffixes.put("minutes", ChronoUnit.MINUTES.getDuration());
            durationSuffixes.put("h", ChronoUnit.HOURS.getDuration());
            durationSuffixes.put("hour", ChronoUnit.HOURS.getDuration());
            durationSuffixes.put("hours", ChronoUnit.HOURS.getDuration());
            durationSuffixes.put("d", ChronoUnit.DAYS.getDuration());
            durationSuffixes.put("day", ChronoUnit.DAYS.getDuration());
            durationSuffixes.put("days", ChronoUnit.DAYS.getDuration());
            durationSuffixes.put("w", ChronoUnit.WEEKS.getDuration());
            durationSuffixes.put("week", ChronoUnit.WEEKS.getDuration());
            durationSuffixes.put("weeks", ChronoUnit.WEEKS.getDuration());
            durationSuffixes.put("month", ChronoUnit.MONTHS.getDuration());
            durationSuffixes.put("months", ChronoUnit.MONTHS.getDuration());
            durationSuffixes.put("y", ChronoUnit.YEARS.getDuration());
            durationSuffixes.put("year", ChronoUnit.YEARS.getDuration());
            durationSuffixes.put("years", ChronoUnit.YEARS.getDuration());
            durationSuffixes.put("decade", ChronoUnit.DECADES.getDuration());
            durationSuffixes.put("decades", ChronoUnit.DECADES.getDuration());
            durationSuffixes.put("century", ChronoUnit.CENTURIES.getDuration());
            durationSuffixes.put("centuries", ChronoUnit.CENTURIES.getDuration());
            durationSuffixes.put("millennia", ChronoUnit.MILLENNIA.getDuration());
            durationSuffixes.put("millennias", ChronoUnit.MILLENNIA.getDuration());
            DURATION_SUFFIXES = Collections.unmodifiableSortedMap(durationSuffixes);
            SECONDS_PER_YEAR = ChronoUnit.YEARS.getDuration().getSeconds();
            SECONDS_PER_MONTH = ChronoUnit.MONTHS.getDuration().getSeconds();
            ArrayList<DateTimeFormatter> zonedDateTimeFormatters = new ArrayList<DateTimeFormatter>();
            zonedDateTimeFormatters.add(DateTimeFormatter.RFC_1123_DATE_TIME);
            zonedDateTimeFormatters.add(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            DateTimeFormatter baseFormatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').toFormatter();
            zonedDateTimeFormatters.add(new DateTimeFormatterBuilder().append(baseFormatter).optionalStart().appendZoneOrOffsetId().toFormatter());
            zonedDateTimeFormatters.add(new DateTimeFormatterBuilder().append(baseFormatter).optionalStart().appendZoneId().toFormatter());
            zonedDateTimeFormatters.add(new DateTimeFormatterBuilder().append(baseFormatter).optionalStart().appendZoneText(TextStyle.FULL).toFormatter());
            zonedDateTimeFormatters.add(new DateTimeFormatterBuilder().append(baseFormatter).optionalStart().appendZoneText(TextStyle.SHORT).toFormatter());
            ZONED_DATE_TIME_FORMATTERS = Collections.unmodifiableList(zonedDateTimeFormatters);
            LOCAL_DATE_TIME_FORMATTERS = Collections.unmodifiableList(Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE_TIME, new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter()));
            OFFSET_TIME_FORMATTERS = Collections.unmodifiableList(Arrays.asList(DateTimeFormatter.ISO_OFFSET_TIME));
            LOCAL_DATE_FORMATTERS = Collections.unmodifiableList(Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE));
            LOCAL_TIME_FORMATTERS = Collections.unmodifiableList(Arrays.asList(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }
}

