/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.coroutines.Continuation;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.okhttp3.Call;
import name.remal.gradle_plugins.internal._relocated.okhttp3.ResponseBody;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Call;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CallAdapter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.KotlinExtensions;
import name.remal.gradle_plugins.internal._relocated.retrofit2.OkHttpCall;
import name.remal.gradle_plugins.internal._relocated.retrofit2.RequestFactory;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Response;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Retrofit;
import name.remal.gradle_plugins.internal._relocated.retrofit2.ServiceMethod;
import name.remal.gradle_plugins.internal._relocated.retrofit2.SkipCallbackExecutorImpl;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Utils;

@RelocatedClass
@Generated
@SuppressFBWarnings
abstract class HttpServiceMethod<ResponseT, ReturnT>
extends ServiceMethod<ReturnT> {
    private final RequestFactory requestFactory;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, ResponseT> responseConverter;

    static <ResponseT, ReturnT> HttpServiceMethod<ResponseT, ReturnT> parseAnnotations(Retrofit retrofit, Method method, RequestFactory requestFactory) {
        Type adapterType;
        Type responseType;
        boolean isKotlinSuspendFunction = requestFactory.isKotlinSuspendFunction;
        boolean continuationWantsResponse = false;
        boolean continuationBodyNullable = false;
        Annotation[] annotations2 = method.getAnnotations();
        if (isKotlinSuspendFunction) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            responseType = Utils.getParameterLowerBound(0, (ParameterizedType)parameterTypes[parameterTypes.length - 1]);
            if (Utils.getRawType(responseType) == Response.class && responseType instanceof ParameterizedType) {
                responseType = Utils.getParameterUpperBound(0, (ParameterizedType)responseType);
                continuationWantsResponse = true;
            }
            adapterType = new Utils.ParameterizedTypeImpl(null, (Type)((Object)Call.class), responseType);
            annotations2 = SkipCallbackExecutorImpl.ensurePresent(annotations2);
        } else {
            adapterType = method.getGenericReturnType();
        }
        CallAdapter<ResponseT, ReturnT> callAdapter = HttpServiceMethod.createCallAdapter(retrofit, method, adapterType, annotations2);
        responseType = callAdapter.responseType();
        if (responseType == name.remal.gradle_plugins.internal._relocated.okhttp3.Response.class) {
            throw Utils.methodError(method, "'" + Utils.getRawType(responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        if (responseType == Response.class) {
            throw Utils.methodError(method, "Response must include generic type (e.g., Response<String>)", new Object[0]);
        }
        if (requestFactory.httpMethod.equals("HEAD") && !Void.class.equals((Object)responseType)) {
            throw Utils.methodError(method, "HEAD method must use Void as response type.", new Object[0]);
        }
        Converter<ResponseBody, ResponseT> responseConverter = HttpServiceMethod.createResponseConverter(retrofit, method, responseType);
        Call.Factory callFactory = retrofit.callFactory;
        if (!isKotlinSuspendFunction) {
            return new CallAdapted<ResponseT, ReturnT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        if (continuationWantsResponse) {
            return new SuspendForResponse<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        return new SuspendForBody<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter, continuationBodyNullable);
    }

    private static <ResponseT, ReturnT> CallAdapter<ResponseT, ReturnT> createCallAdapter(Retrofit retrofit, Method method, Type returnType, Annotation[] annotations2) {
        try {
            return retrofit.callAdapter(returnType, annotations2);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create call adapter for %s", returnType);
        }
    }

    private static <ResponseT> Converter<ResponseBody, ResponseT> createResponseConverter(Retrofit retrofit, Method method, Type responseType) {
        Annotation[] annotations2 = method.getAnnotations();
        try {
            return retrofit.responseBodyConverter(responseType, annotations2);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create converter for %s", responseType);
        }
    }

    HttpServiceMethod(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter) {
        this.requestFactory = requestFactory;
        this.callFactory = callFactory;
        this.responseConverter = responseConverter;
    }

    @Override
    @Nullable
    final ReturnT invoke(Object[] args) {
        OkHttpCall<ResponseT> call = new OkHttpCall<ResponseT>(this.requestFactory, args, this.callFactory, this.responseConverter);
        return this.adapt(call, args);
    }

    @Nullable
    protected abstract ReturnT adapt(Call<ResponseT> var1, Object[] var2);

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class CallAdapted<ResponseT, ReturnT>
    extends HttpServiceMethod<ResponseT, ReturnT> {
        private final CallAdapter<ResponseT, ReturnT> callAdapter;

        CallAdapted(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, ReturnT> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected ReturnT adapt(Call<ResponseT> call, Object[] args) {
            return this.callAdapter.adapt(call);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class SuspendForResponse<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;

        SuspendForResponse(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                return KotlinExtensions.awaitResponse(call, continuation);
            }
            catch (Exception e) {
                return KotlinExtensions.suspendAndThrow(e, continuation);
            }
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class SuspendForBody<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;
        private final boolean isNullable;

        SuspendForBody(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter, boolean isNullable) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
            this.isNullable = isNullable;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                return this.isNullable ? KotlinExtensions.awaitNullable(call, continuation) : KotlinExtensions.await(call, continuation);
            }
            catch (Exception e) {
                return KotlinExtensions.suspendAndThrow(e, continuation);
            }
        }
    }
}

