/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.module.paramnames;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Executable;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Parameter;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonCreator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.cfg.MapperConfig;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.Annotated;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.module.paramnames.ParameterExtractor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class ParameterNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private final JsonCreator.Mode creatorBinding;
    private final ParameterExtractor parameterExtractor;

    ParameterNamesAnnotationIntrospector(JsonCreator.Mode creatorBinding, ParameterExtractor parameterExtractor) {
        this.creatorBinding = creatorBinding;
        this.parameterExtractor = parameterExtractor;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember m) {
        if (m instanceof AnnotatedParameter) {
            return this.findParameterName((AnnotatedParameter)m);
        }
        return null;
    }

    private String findParameterName(AnnotatedParameter annotatedParameter) {
        Parameter[] params;
        try {
            params = this.getParameters(annotatedParameter.getOwner());
        }
        catch (MalformedParametersException e) {
            return null;
        }
        Parameter p = params[annotatedParameter.getIndex()];
        return p.isNamePresent() ? p.getName() : null;
    }

    private Parameter[] getParameters(AnnotatedWithParams owner) {
        if (owner instanceof AnnotatedConstructor) {
            return this.parameterExtractor.getParameters((Executable)((AnnotatedConstructor)owner).getAnnotated());
        }
        if (owner instanceof AnnotatedMethod) {
            return this.parameterExtractor.getParameters(((AnnotatedMethod)owner).getAnnotated());
        }
        return null;
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        JsonCreator ann = this._findAnnotation(a, JsonCreator.class);
        if (ann != null) {
            JsonCreator.Mode mode = ann.mode();
            if (this.creatorBinding != null && mode == JsonCreator.Mode.DEFAULT) {
                mode = this.creatorBinding;
            }
            return mode;
        }
        return null;
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated a) {
        JsonCreator ann = this._findAnnotation(a, JsonCreator.class);
        if (ann != null) {
            JsonCreator.Mode mode = ann.mode();
            if (this.creatorBinding != null && mode == JsonCreator.Mode.DEFAULT) {
                mode = this.creatorBinding;
            }
            return mode;
        }
        return this.creatorBinding;
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated a) {
        JsonCreator ann = this._findAnnotation(a, JsonCreator.class);
        if (ann != null) {
            return ann.mode() != JsonCreator.Mode.DISABLED;
        }
        return false;
    }
}

