/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins.internal._relocated.com.google.common.base.Optional;
import name.remal.gradle_plugins.internal._relocated.com.google.common.collect.ImmutableCollection;
import name.remal.gradle_plugins.internal._relocated.com.google.common.collect.ImmutableList;
import name.remal.gradle_plugins.internal._relocated.com.google.common.collect.Lists;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.AggregateFuture;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.ListenableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    private List<Optional<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        this.values = futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size());
        for (int i2 = 0; i2 < futures.size(); ++i2) {
            this.values.add(null);
        }
    }

    @Override
    final void collectOneValue(int index, @Nullable V returnValue) {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, Optional.fromNullable(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<Optional<V>> var1);

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<V> combine(List<Optional<V>> values2) {
            ArrayList<Object> result2 = Lists.newArrayListWithCapacity(values2.size());
            for (Optional<V> element : values2) {
                result2.add(element != null ? (Object)element.orNull() : null);
            }
            return Collections.unmodifiableList(result2);
        }
    }
}

