/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassGraph;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.Classfile;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElement;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElementFileDir;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElementModule;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElementPathDir;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElementZip;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ModuleInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ModuleRef;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.PackageInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.Resource;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classpath.ClasspathFinder;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classpath.ModuleFinder;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.AutoCloseableExecutorService;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.SingletonMap;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.WorkQueue;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.CollectionUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FastPathResolver;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.JarUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    public boolean performScan;
    private final NestedJarHandler nestedJarHandler;
    private final ExecutorService executorService;
    private final InterruptionChecker interruptionChecker;
    private final int numParallelTasks;
    private final ClassGraph.ScanResultProcessor scanResultProcessor;
    private final ClassGraph.FailureHandler failureHandler;
    private final LogNode topLevelLog;
    private final ClasspathFinder classpathFinder;
    private final List<ClasspathElementModule> moduleOrder;
    private final ClassLoader[] classLoaderOrderRespectingParentDelegation;
    private static final Comparator<Map.Entry<Integer, ClasspathElement>> INDEXED_CLASSPATH_ELEMENT_COMPARATOR = new Comparator<Map.Entry<Integer, ClasspathElement>>(){

        @Override
        public int compare(Map.Entry<Integer, ClasspathElement> o1, Map.Entry<Integer, ClasspathElement> o2) {
            return o1.getKey() - o2.getKey();
        }
    };
    private final SingletonMap<ClasspathOrder.ClasspathElementAndClassLoader, ClasspathElement, IOException> classpathEntryToClasspathElementSingletonMap = new SingletonMap<ClasspathOrder.ClasspathElementAndClassLoader, ClasspathElement, IOException>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ClasspathElement newInstance(ClasspathOrder.ClasspathElementAndClassLoader classpathEntry, LogNode log) throws IOException, InterruptedException {
            ClasspathElement classpathElement;
            String canonicalPathNormalized;
            boolean isJar;
            String pathNormalized;
            int plingIdx;
            String pathToCanonicalize;
            File fileCanonicalized;
            String classpathEntryPathStr;
            String dirOrPathPackageRoot;
            block25: {
                String classpathEntryStr;
                Object classpathEntryObj = classpathEntry.classpathElementRoot;
                dirOrPathPackageRoot = classpathEntry.dirOrPathPackageRoot;
                while (dirOrPathPackageRoot.startsWith("/")) {
                    dirOrPathPackageRoot = dirOrPathPackageRoot.substring(1);
                }
                if (classpathEntryObj instanceof String && JarUtils.URL_SCHEME_PATTERN.matcher(classpathEntryStr = (String)classpathEntryObj).matches()) {
                    try {
                        classpathEntryObj = new URL(classpathEntryStr);
                    }
                    catch (MalformedURLException e) {
                        throw new IOException("Malformed URL: " + classpathEntryStr);
                    }
                }
                if (classpathEntryObj instanceof URL) {
                    URL classpathEntryURL = (URL)classpathEntryObj;
                    String scheme = classpathEntryURL.getProtocol();
                    if ("jar".equals(scheme)) {
                        try {
                            classpathEntryURL = new URL(URLDecoder.decode(classpathEntryURL.toString(), "UTF-8").substring(4));
                            scheme = classpathEntryURL.getProtocol();
                        }
                        catch (MalformedURLException e) {
                            throw new IOException("Could not strip 'jar:' prefix from " + classpathEntryObj, e);
                        }
                    }
                    if ("file".equals(scheme)) {
                        classpathEntryPathStr = URLDecoder.decode(classpathEntryURL.getPath(), "UTF-8");
                        break block25;
                    } else {
                        if ("http".equals(scheme)) return new ClasspathElementZip(classpathEntryURL, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                        if ("https".equals(scheme)) {
                            return new ClasspathElementZip(classpathEntryURL, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                        }
                        try {
                            Path path = Paths.get(classpathEntryURL.toURI());
                            if (!Files.isDirectory(path, new LinkOption[0])) return new ClasspathElementZip(classpathEntryURL, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                            return new ClasspathElementPathDir(path, dirOrPathPackageRoot, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                        }
                        catch (IllegalArgumentException | SecurityException | URISyntaxException e) {
                            throw new IOException("Cannot handle URL " + classpathEntryURL + " : " + e.getMessage());
                        }
                        catch (FileSystemNotFoundException e) {
                            // empty catch block
                        }
                        return new ClasspathElementZip(classpathEntryURL, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                    }
                }
                if (classpathEntryObj instanceof Path) {
                    Path classpathEntryPath = (Path)classpathEntryObj;
                    Path packageRootPath = classpathEntryPath.resolve(dirOrPathPackageRoot);
                    if (FileUtils.canReadAndIsFile(packageRootPath)) {
                        return new ClasspathElementZip(classpathEntryPath.toUri(), classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                    }
                    if (!FileUtils.canReadAndIsDir(packageRootPath)) throw new IOException("Path is not a directory or file: " + classpathEntryPath);
                    return new ClasspathElementPathDir((Path)classpathEntryObj, dirOrPathPackageRoot, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                }
                classpathEntryPathStr = classpathEntryObj.toString();
            }
            if (!(fileCanonicalized = new File(pathToCanonicalize = (plingIdx = (pathNormalized = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, classpathEntryPathStr)).indexOf(33)) < 0 ? pathNormalized : pathNormalized.substring(0, plingIdx)).getCanonicalFile()).exists()) {
                throw new FileNotFoundException();
            }
            if (!FileUtils.canRead(fileCanonicalized)) {
                throw new IOException("Cannot read file or directory");
            }
            boolean bl = isJar = classpathEntryPathStr.regionMatches(true, 0, "jar:", 0, 4) || plingIdx > 0;
            if (fileCanonicalized.isFile()) {
                isJar = true;
            } else {
                if (!fileCanonicalized.isDirectory()) throw new IOException("Not a normal file or directory");
                if (isJar) {
                    throw new IOException("Expected jar, found directory");
                }
            }
            String baseFileCanonicalPathNormalized = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, fileCanonicalized.getPath());
            String string = canonicalPathNormalized = plingIdx < 0 ? baseFileCanonicalPathNormalized : baseFileCanonicalPathNormalized + pathNormalized.substring(plingIdx);
            if (!canonicalPathNormalized.equals(pathNormalized)) {
                try {
                    return (ClasspathElement)this.get(new ClasspathOrder.ClasspathElementAndClassLoader(canonicalPathNormalized, dirOrPathPackageRoot, classpathEntry.classLoader), log);
                }
                catch (SingletonMap.NullSingletonException e) {
                    throw new IOException("Cannot get classpath element for canonical path " + canonicalPathNormalized + " : " + e);
                }
            }
            if (isJar) {
                classpathElement = new ClasspathElementZip(canonicalPathNormalized, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
                return classpathElement;
            }
            classpathElement = new ClasspathElementFileDir(fileCanonicalized, dirOrPathPackageRoot, classpathEntry.classLoader, Scanner.this.nestedJarHandler, Scanner.this.scanSpec);
            return classpathElement;
        }
    };

    Scanner(boolean performScan, ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, ClassGraph.ScanResultProcessor scanResultProcessor, ClassGraph.FailureHandler failureHandler, LogNode topLevelLog) throws InterruptedException {
        this.scanSpec = scanSpec;
        this.performScan = performScan;
        scanSpec.sortPrefixes();
        scanSpec.log(topLevelLog);
        if (topLevelLog != null) {
            if (scanSpec.pathAcceptReject != null && scanSpec.packagePrefixAcceptReject.isSpecificallyAccepted("")) {
                topLevelLog.log("Note: There is no need to accept the root package (\"\") -- not accepting anything will have the same effect of causing all packages to be scanned");
            }
            topLevelLog.log("Number of worker threads: " + numParallelTasks);
        }
        this.executorService = executorService;
        this.interruptionChecker = executorService instanceof AutoCloseableExecutorService ? ((AutoCloseableExecutorService)executorService).interruptionChecker : new InterruptionChecker();
        this.nestedJarHandler = new NestedJarHandler(scanSpec, this.interruptionChecker);
        this.numParallelTasks = numParallelTasks;
        this.scanResultProcessor = scanResultProcessor;
        this.failureHandler = failureHandler;
        this.topLevelLog = topLevelLog;
        LogNode classpathFinderLog = topLevelLog == null ? null : topLevelLog.log("Finding classpath");
        this.classpathFinder = new ClasspathFinder(scanSpec, classpathFinderLog);
        this.classLoaderOrderRespectingParentDelegation = this.classpathFinder.getClassLoaderOrderRespectingParentDelegation();
        try {
            this.moduleOrder = new ArrayList<ClasspathElementModule>();
            ModuleFinder moduleFinder = this.classpathFinder.getModuleFinder();
            if (moduleFinder != null) {
                List<ModuleRef> nonSystemModuleRefs;
                ClassLoader defaultClassLoader;
                List<ModuleRef> systemModuleRefs = moduleFinder.getSystemModuleRefs();
                ClassLoader classLoader = defaultClassLoader = this.classLoaderOrderRespectingParentDelegation != null && this.classLoaderOrderRespectingParentDelegation.length != 0 ? this.classLoaderOrderRespectingParentDelegation[0] : null;
                if (systemModuleRefs != null) {
                    for (ModuleRef systemModuleRef : systemModuleRefs) {
                        String moduleName2 = systemModuleRef.getName();
                        if (scanSpec.enableSystemJarsAndModules && scanSpec.moduleAcceptReject.acceptAndRejectAreEmpty() || scanSpec.moduleAcceptReject.isSpecificallyAcceptedAndNotRejected(moduleName2)) {
                            ClasspathElementModule classpathElementModule = new ClasspathElementModule(systemModuleRef, defaultClassLoader, this.nestedJarHandler.moduleRefToModuleReaderProxyRecyclerMap, scanSpec);
                            this.moduleOrder.add(classpathElementModule);
                            classpathElementModule.open(null, classpathFinderLog);
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping non-accepted or rejected system module: " + moduleName2);
                    }
                }
                if ((nonSystemModuleRefs = moduleFinder.getNonSystemModuleRefs()) != null) {
                    for (ModuleRef nonSystemModuleRef : nonSystemModuleRefs) {
                        String moduleName3 = nonSystemModuleRef.getName();
                        if (moduleName3 == null) {
                            moduleName3 = "";
                        }
                        if (scanSpec.moduleAcceptReject.isAcceptedAndNotRejected(moduleName3)) {
                            ClasspathElementModule classpathElementModule = new ClasspathElementModule(nonSystemModuleRef, defaultClassLoader, this.nestedJarHandler.moduleRefToModuleReaderProxyRecyclerMap, scanSpec);
                            this.moduleOrder.add(classpathElementModule);
                            classpathElementModule.open(null, classpathFinderLog);
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping non-accepted or rejected module: " + moduleName3);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.nestedJarHandler.close(null);
            throw e;
        }
    }

    private static void findClasspathOrderRec(ClasspathElement currClasspathElement, Set<ClasspathElement> visitedClasspathElts, List<ClasspathElement> order) {
        if (visitedClasspathElts.add(currClasspathElement)) {
            if (!currClasspathElement.skipClasspathElement) {
                order.add(currClasspathElement);
            }
            for (ClasspathElement childClasspathElt : currClasspathElement.childClasspathElementsOrdered) {
                Scanner.findClasspathOrderRec(childClasspathElt, visitedClasspathElts, order);
            }
        }
    }

    private static List<ClasspathElement> orderClasspathElements(Collection<Map.Entry<Integer, ClasspathElement>> classpathEltsIndexed) {
        ArrayList<Map.Entry<Integer, ClasspathElement>> classpathEltsIndexedOrdered = new ArrayList<Map.Entry<Integer, ClasspathElement>>(classpathEltsIndexed);
        CollectionUtils.sortIfNotEmpty(classpathEltsIndexedOrdered, INDEXED_CLASSPATH_ELEMENT_COMPARATOR);
        ArrayList<ClasspathElement> classpathEltsOrdered = new ArrayList<ClasspathElement>(classpathEltsIndexedOrdered.size());
        for (Map.Entry entry : classpathEltsIndexedOrdered) {
            classpathEltsOrdered.add((ClasspathElement)entry.getValue());
        }
        return classpathEltsOrdered;
    }

    private List<ClasspathElement> findClasspathOrder(Set<ClasspathElement> uniqueClasspathElements, Queue<Map.Entry<Integer, ClasspathElement>> toplevelClasspathEltsIndexed) {
        List<ClasspathElement> toplevelClasspathEltsOrdered = Scanner.orderClasspathElements(toplevelClasspathEltsIndexed);
        for (ClasspathElement classpathElt : uniqueClasspathElements) {
            classpathElt.childClasspathElementsOrdered = Scanner.orderClasspathElements(classpathElt.childClasspathElementsIndexed);
        }
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathElement toplevelClasspathElt : toplevelClasspathEltsOrdered) {
            Scanner.findClasspathOrderRec(toplevelClasspathElt, visitedClasspathElts, order);
        }
        return order;
    }

    private <W> void processWorkUnits(Collection<W> workUnits, LogNode log, WorkQueue.WorkUnitProcessor<W> workUnitProcessor) throws InterruptedException, ExecutionException {
        WorkQueue.runWorkQueue(workUnits, this.executorService, this.interruptionChecker, this.numParallelTasks, log, workUnitProcessor);
        if (log != null) {
            log.addElapsedTime();
        }
        this.interruptionChecker.check();
    }

    private WorkQueue.WorkUnitProcessor<ClasspathEntryWorkUnit> newClasspathEntryWorkUnitProcessor(final Set<ClasspathElement> openedClasspathElementsSet, final Queue<Map.Entry<Integer, ClasspathElement>> toplevelClasspathEltOrder) {
        return new WorkQueue.WorkUnitProcessor<ClasspathEntryWorkUnit>(){

            @Override
            public void processWorkUnit(ClasspathEntryWorkUnit workUnit, WorkQueue<ClasspathEntryWorkUnit> workQueue, LogNode log) throws InterruptedException {
                block7: {
                    try {
                        ClasspathElement classpathElt;
                        try {
                            classpathElt = (ClasspathElement)Scanner.this.classpathEntryToClasspathElementSingletonMap.get(workUnit.rawClasspathEntry, log);
                        }
                        catch (SingletonMap.NullSingletonException e) {
                            throw new IOException("Cannot get classpath element for classpath entry " + workUnit.rawClasspathEntry + " : " + e);
                        }
                        if (openedClasspathElementsSet.add(classpathElt)) {
                            LogNode subLog = log == null ? null : log.log("Opening classpath element " + classpathElt);
                            classpathElt.open(workQueue, subLog);
                            AbstractMap.SimpleEntry<Integer, ClasspathElement> classpathEltEntry = new AbstractMap.SimpleEntry<Integer, ClasspathElement>(workUnit.orderWithinParentClasspathElement, classpathElt);
                            if (workUnit.parentClasspathElement != null) {
                                ((ClasspathEntryWorkUnit)workUnit).parentClasspathElement.childClasspathElementsIndexed.add(classpathEltEntry);
                            } else {
                                toplevelClasspathEltOrder.add(classpathEltEntry);
                            }
                        }
                    }
                    catch (IOException | SecurityException e) {
                        if (log == null) break block7;
                        log.log("Skipping invalid classpath element " + ((ClasspathEntryWorkUnit)workUnit).rawClasspathEntry.classpathElementRoot + (((ClasspathEntryWorkUnit)workUnit).rawClasspathEntry.dirOrPathPackageRoot.isEmpty() ? "" : "/" + ((ClasspathEntryWorkUnit)workUnit).rawClasspathEntry.dirOrPathPackageRoot) + " : " + e);
                    }
                }
            }
        };
    }

    private void findNestedClasspathElements(List<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathElts, LogNode log) {
        CollectionUtils.sortIfNotEmpty(classpathElts, new Comparator<AbstractMap.SimpleEntry<String, ClasspathElement>>(){

            @Override
            public int compare(AbstractMap.SimpleEntry<String, ClasspathElement> o1, AbstractMap.SimpleEntry<String, ClasspathElement> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        block0: for (int i2 = 0; i2 < classpathElts.size(); ++i2) {
            AbstractMap.SimpleEntry<String, ClasspathElement> ei = classpathElts.get(i2);
            String basePath = ei.getKey();
            int basePathLen = basePath.length();
            for (int j = i2 + 1; j < classpathElts.size(); ++j) {
                String nestedClasspathRelativePath;
                char nextChar;
                AbstractMap.SimpleEntry<String, ClasspathElement> ej = classpathElts.get(j);
                String comparePath = ej.getKey();
                int comparePathLen = comparePath.length();
                boolean foundNestedClasspathRoot = false;
                if (comparePath.startsWith(basePath) && comparePathLen > basePathLen && ((nextChar = comparePath.charAt(basePathLen)) == '/' || nextChar == '!') && (nestedClasspathRelativePath = comparePath.substring(basePathLen + 1)).indexOf(33) < 0) {
                    foundNestedClasspathRoot = true;
                    ClasspathElement baseElement = ei.getValue();
                    if (baseElement.nestedClasspathRootPrefixes == null) {
                        baseElement.nestedClasspathRootPrefixes = new ArrayList<String>();
                    }
                    baseElement.nestedClasspathRootPrefixes.add(nestedClasspathRelativePath + "/");
                    if (log != null) {
                        log.log(basePath + " is a prefix of the nested element " + comparePath);
                    }
                }
                if (!foundNestedClasspathRoot) continue block0;
            }
        }
    }

    private void preprocessClasspathElementsByType(List<ClasspathElement> finalTraditionalClasspathEltOrder, LogNode classpathFinderLog) {
        ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltDirs = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
        ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltZips = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
        for (ClasspathElement classpathElt : finalTraditionalClasspathEltOrder) {
            if (classpathElt instanceof ClasspathElementFileDir) {
                classpathEltDirs.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(((ClasspathElementFileDir)classpathElt).getFile().getPath(), classpathElt));
                continue;
            }
            if (!(classpathElt instanceof ClasspathElementZip)) continue;
            ClasspathElementZip classpathEltZip = (ClasspathElementZip)classpathElt;
            classpathEltZips.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(classpathEltZip.getZipFilePath(), classpathElt));
            if (classpathEltZip.logicalZipFile == null) continue;
            if (classpathEltZip.logicalZipFile.addExportsManifestEntryValue != null) {
                for (String addExports : JarUtils.smartPathSplit(classpathEltZip.logicalZipFile.addExportsManifestEntryValue, ' ', this.scanSpec)) {
                    this.scanSpec.modulePathInfo.addExports.add(addExports + "=ALL-UNNAMED");
                }
            }
            if (classpathEltZip.logicalZipFile.addOpensManifestEntryValue != null) {
                for (String addOpens : JarUtils.smartPathSplit(classpathEltZip.logicalZipFile.addOpensManifestEntryValue, ' ', this.scanSpec)) {
                    this.scanSpec.modulePathInfo.addOpens.add(addOpens + "=ALL-UNNAMED");
                }
            }
            if (classpathEltZip.logicalZipFile.automaticModuleNameManifestEntryValue == null) continue;
            classpathEltZip.moduleNameFromManifestFile = classpathEltZip.logicalZipFile.automaticModuleNameManifestEntryValue;
        }
        this.findNestedClasspathElements(classpathEltDirs, classpathFinderLog);
        this.findNestedClasspathElements(classpathEltZips, classpathFinderLog);
    }

    private void maskClassfiles(List<ClasspathElement> classpathElementOrder, LogNode maskLog) {
        HashSet<String> acceptedClasspathRelativePathsFound = new HashSet<String>();
        for (int classpathIdx = 0; classpathIdx < classpathElementOrder.size(); ++classpathIdx) {
            ClasspathElement classpathElement = classpathElementOrder.get(classpathIdx);
            classpathElement.maskClassfiles(classpathIdx, acceptedClasspathRelativePathsFound, maskLog);
        }
        if (maskLog != null) {
            maskLog.addElapsedTime();
        }
    }

    private ScanResult performScan(List<ClasspathElement> finalClasspathEltOrder, List<String> finalClasspathEltOrderStrs, ClassLoader[] classLoaderOrderRespectingParentDelegation) throws InterruptedException, ExecutionException {
        if (this.scanSpec.enableClassInfo) {
            this.maskClassfiles(finalClasspathEltOrder, this.topLevelLog == null ? null : this.topLevelLog.log("Masking classfiles"));
        }
        HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
        for (ClasspathElement classpathElement : finalClasspathEltOrder) {
            fileToLastModified.putAll(classpathElement.fileToLastModified);
        }
        ConcurrentHashMap<String, ClassInfo> classNameToClassInfo = new ConcurrentHashMap<String, ClassInfo>();
        HashMap<String, PackageInfo> packageNameToPackageInfo = new HashMap<String, PackageInfo>();
        HashMap<String, ModuleInfo> moduleNameToModuleInfo = new HashMap<String, ModuleInfo>();
        if (this.scanSpec.enableClassInfo) {
            LogNode linkLog;
            ArrayList<ClassfileScanWorkUnit> classfileScanWorkItems = new ArrayList<ClassfileScanWorkUnit>();
            HashSet<String> acceptedClassNamesFound = new HashSet<String>();
            for (ClasspathElement classpathElement : finalClasspathEltOrder) {
                for (Resource resource2 : classpathElement.acceptedClassfileResources) {
                    String className = JarUtils.classfilePathToClassName(resource2.getPath());
                    if (!(acceptedClassNamesFound.add(className) || className.equals("module-info") || className.equals("package-info") || className.endsWith(".package-info"))) {
                        throw new IllegalArgumentException("Class " + className + " should not have been scheduled more than once for scanning due to classpath masking -- please report this bug at: https://github.com/classgraph/classgraph/issues");
                    }
                    classfileScanWorkItems.add(new ClassfileScanWorkUnit(classpathElement, resource2, false));
                }
            }
            ConcurrentLinkedQueue<Classfile> scannedClassfiles = new ConcurrentLinkedQueue<Classfile>();
            ClassfileScannerWorkUnitProcessor classfileWorkUnitProcessor = new ClassfileScannerWorkUnitProcessor(this.scanSpec, finalClasspathEltOrder, Collections.unmodifiableSet(acceptedClassNamesFound), scannedClassfiles);
            this.processWorkUnits(classfileScanWorkItems, this.topLevelLog == null ? null : this.topLevelLog.log("Scanning classfiles"), classfileWorkUnitProcessor);
            LogNode logNode = linkLog = this.topLevelLog == null ? null : this.topLevelLog.log("Linking related classfiles");
            while (!scannedClassfiles.isEmpty()) {
                Classfile c = (Classfile)scannedClassfiles.remove();
                c.link(classNameToClassInfo, packageNameToPackageInfo, moduleNameToModuleInfo);
            }
            if (linkLog != null) {
                linkLog.addElapsedTime();
            }
        } else if (this.topLevelLog != null) {
            this.topLevelLog.log("Classfile scanning is disabled");
        }
        return new ScanResult(this.scanSpec, finalClasspathEltOrder, finalClasspathEltOrderStrs, classLoaderOrderRespectingParentDelegation, classNameToClassInfo, packageNameToPackageInfo, moduleNameToModuleInfo, fileToLastModified, this.nestedJarHandler, this.topLevelLog);
    }

    private ScanResult openClasspathElementsThenScan() throws InterruptedException, ExecutionException {
        ArrayList<ClasspathEntryWorkUnit> rawClasspathEntryWorkUnits = new ArrayList<ClasspathEntryWorkUnit>();
        for (ClasspathOrder.ClasspathElementAndClassLoader rawClasspathEntry : this.classpathFinder.getClasspathOrder().getOrder()) {
            rawClasspathEntryWorkUnits.add(new ClasspathEntryWorkUnit(rawClasspathEntry, null, rawClasspathEntryWorkUnits.size()));
        }
        Set<ClasspathElement> openedClasspathEltsSet = Collections.newSetFromMap(new ConcurrentHashMap());
        ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>> toplevelClasspathEltOrder = new ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>>();
        this.processWorkUnits(rawClasspathEntryWorkUnits, this.topLevelLog == null ? null : this.topLevelLog.log("Opening classpath elements"), this.newClasspathEntryWorkUnitProcessor(openedClasspathEltsSet, toplevelClasspathEltOrder));
        List<ClasspathElement> classpathEltOrder = this.findClasspathOrder(openedClasspathEltsSet, toplevelClasspathEltOrder);
        this.preprocessClasspathElementsByType(classpathEltOrder, this.topLevelLog == null ? null : this.topLevelLog.log("Finding nested classpath elements"));
        LogNode classpathOrderLog = this.topLevelLog == null ? null : this.topLevelLog.log("Final classpath element order:");
        int numElts = this.moduleOrder.size() + classpathEltOrder.size();
        ArrayList<ClasspathElement> finalClasspathEltOrder = new ArrayList<ClasspathElement>(numElts);
        ArrayList<String> finalClasspathEltOrderStrs = new ArrayList<String>(numElts);
        int classpathOrderIdx = 0;
        for (ClasspathElementModule classpathElementModule : this.moduleOrder) {
            classpathElementModule.classpathElementIdx = classpathOrderIdx++;
            finalClasspathEltOrder.add(classpathElementModule);
            finalClasspathEltOrderStrs.add(classpathElementModule.toString());
            if (classpathOrderLog == null) continue;
            ModuleRef moduleRef = classpathElementModule.getModuleRef();
            classpathOrderLog.log(moduleRef.toString());
        }
        for (ClasspathElement classpathElement : classpathEltOrder) {
            classpathElement.classpathElementIdx = classpathOrderIdx++;
            finalClasspathEltOrder.add(classpathElement);
            finalClasspathEltOrderStrs.add(classpathElement.toString());
            if (classpathOrderLog == null) continue;
            classpathOrderLog.log(classpathElement.toString());
        }
        this.processWorkUnits(finalClasspathEltOrder, this.topLevelLog == null ? null : this.topLevelLog.log("Scanning classpath elements"), new WorkQueue.WorkUnitProcessor<ClasspathElement>(){

            @Override
            public void processWorkUnit(ClasspathElement classpathElement, WorkQueue<ClasspathElement> workQueueIgnored, LogNode pathScanLog) throws InterruptedException {
                classpathElement.scanPaths(pathScanLog);
            }
        });
        ArrayList<ClasspathElement> finalClasspathEltOrderFiltered = finalClasspathEltOrder;
        if (!this.scanSpec.classpathElementResourcePathAcceptReject.acceptIsEmpty()) {
            finalClasspathEltOrderFiltered = new ArrayList(finalClasspathEltOrder.size());
            for (ClasspathElement classpathElement : finalClasspathEltOrder) {
                if (!classpathElement.containsSpecificallyAcceptedClasspathElementResourcePath) continue;
                finalClasspathEltOrderFiltered.add(classpathElement);
            }
        }
        if (this.performScan) {
            return this.performScan(finalClasspathEltOrderFiltered, finalClasspathEltOrderStrs, this.classLoaderOrderRespectingParentDelegation);
        }
        if (this.topLevelLog != null) {
            this.topLevelLog.log("Only returning classpath elements (not performing a scan)");
        }
        return new ScanResult(this.scanSpec, finalClasspathEltOrderFiltered, finalClasspathEltOrderStrs, this.classLoaderOrderRespectingParentDelegation, null, null, null, null, this.nestedJarHandler, this.topLevelLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult call() throws InterruptedException, CancellationException, ExecutionException {
        ScanResult scanResult;
        block15: {
            scanResult = null;
            long scanStart = System.currentTimeMillis();
            boolean removeTemporaryFilesAfterScan = this.scanSpec.removeTemporaryFilesAfterScan;
            try {
                scanResult = this.openClasspathElementsThenScan();
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("~", String.format("Total time: %.3f sec", (double)(System.currentTimeMillis() - scanStart) * 0.001));
                    this.topLevelLog.flush();
                }
                if (this.scanResultProcessor == null) break block15;
                try {
                    this.scanResultProcessor.processScanResult(scanResult);
                }
                finally {
                    scanResult.close();
                }
            }
            catch (Throwable e) {
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("~", e instanceof InterruptedException || e instanceof CancellationException ? "Scan interrupted or canceled" : (e instanceof ExecutionException || e instanceof RuntimeException ? "Uncaught exception during scan" : e.getMessage()), InterruptionChecker.getCause(e));
                    this.topLevelLog.flush();
                }
                removeTemporaryFilesAfterScan = true;
                this.interruptionChecker.interrupt();
                if (this.failureHandler == null) {
                    throw e;
                }
                try {
                    this.failureHandler.onFailure(e);
                }
                catch (Exception f) {
                    if (this.topLevelLog != null) {
                        this.topLevelLog.log("~", "The failure handler threw an exception:", (Throwable)f);
                        this.topLevelLog.flush();
                    }
                    ExecutionException failureHandlerException = new ExecutionException("Exception while calling failure handler", f);
                    failureHandlerException.addSuppressed(e);
                    throw failureHandlerException;
                }
            }
            finally {
                if (removeTemporaryFilesAfterScan) {
                    this.nestedJarHandler.close(this.topLevelLog);
                }
            }
        }
        return scanResult;
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static class ClassfileScannerWorkUnitProcessor
    implements WorkQueue.WorkUnitProcessor<ClassfileScanWorkUnit> {
        private final ScanSpec scanSpec;
        private final List<ClasspathElement> classpathOrder;
        private final Set<String> acceptedClassNamesFound;
        private final Set<String> classNamesScheduledForExtendedScanning = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Queue<Classfile> scannedClassfiles;
        private final ConcurrentHashMap<String, String> stringInternMap = new ConcurrentHashMap();

        public ClassfileScannerWorkUnitProcessor(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, Set<String> acceptedClassNamesFound, Queue<Classfile> scannedClassfiles) {
            this.scanSpec = scanSpec;
            this.classpathOrder = classpathOrder;
            this.acceptedClassNamesFound = acceptedClassNamesFound;
            this.scannedClassfiles = scannedClassfiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processWorkUnit(ClassfileScanWorkUnit workUnit, WorkQueue<ClassfileScanWorkUnit> workQueue, LogNode log) throws InterruptedException {
            LogNode subLog = ((ClassfileScanWorkUnit)workUnit).classfileResource.scanLog == null ? null : ((ClassfileScanWorkUnit)workUnit).classfileResource.scanLog.log(workUnit.classfileResource.getPath(), "Parsing classfile");
            try {
                Classfile classfile = new Classfile(workUnit.classpathElement, this.classpathOrder, this.acceptedClassNamesFound, this.classNamesScheduledForExtendedScanning, workUnit.classfileResource.getPath(), workUnit.classfileResource, workUnit.isExternalClass, this.stringInternMap, workQueue, this.scanSpec, subLog);
                this.scannedClassfiles.add(classfile);
            }
            catch (Classfile.SkipClassException e) {
                if (subLog != null) {
                    subLog.log(workUnit.classfileResource.getPath(), "Skipping classfile: " + e.getMessage());
                }
            }
            catch (Classfile.ClassfileFormatException e) {
                if (subLog != null) {
                    subLog.log(workUnit.classfileResource.getPath(), "Invalid classfile: " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (subLog != null) {
                    subLog.log(workUnit.classfileResource.getPath(), "Could not read classfile: " + e);
                }
            }
            finally {
                if (subLog != null) {
                    subLog.addElapsedTime();
                }
            }
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    static class ClassfileScanWorkUnit {
        private final ClasspathElement classpathElement;
        private final Resource classfileResource;
        private final boolean isExternalClass;

        ClassfileScanWorkUnit(ClasspathElement classpathElement, Resource classfileResource, boolean isExternalClass) {
            this.classpathElement = classpathElement;
            this.classfileResource = classfileResource;
            this.isExternalClass = isExternalClass;
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    static class ClasspathEntryWorkUnit {
        private final ClasspathOrder.ClasspathElementAndClassLoader rawClasspathEntry;
        private final ClasspathElement parentClasspathElement;
        private final int orderWithinParentClasspathElement;

        public ClasspathEntryWorkUnit(ClasspathOrder.ClasspathElementAndClassLoader rawClasspathEntry, ClasspathElement parentClasspathElement, int orderWithinParentClasspathElement) {
            this.rawClasspathEntry = rawClasspathEntry;
            this.parentClasspathElement = parentClasspathElement;
            this.orderWithinParentClasspathElement = orderWithinParentClasspathElement;
        }
    }
}

