/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.VersionFinder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class URLPathEncoder {
    private static boolean[] safe;
    private static final char[] HEXADECIMAL;
    private static final String[] SCHEME_PREFIXES;

    private URLPathEncoder() {
    }

    public static String encodePath(String path) {
        int validColonPrefixLen = 0;
        for (String scheme : SCHEME_PREFIXES) {
            if (!path.startsWith(scheme)) continue;
            validColonPrefixLen = scheme.length();
            break;
        }
        if (VersionFinder.OS == VersionFinder.OperatingSystem.Windows) {
            int i2 = validColonPrefixLen;
            if (i2 < path.length() && path.charAt(i2) == '/') {
                ++i2;
            }
            if (i2 < path.length() - 1 && Character.isLetter(path.charAt(i2)) && path.charAt(i2 + 1) == ':') {
                validColonPrefixLen = i2 + 2;
            }
        }
        byte[] pathBytes = path.getBytes(StandardCharsets.UTF_8);
        StringBuilder encodedPath = new StringBuilder(pathBytes.length * 3);
        for (int i3 = 0; i3 < pathBytes.length; ++i3) {
            byte pathByte = pathBytes[i3];
            int b = pathByte & 0xFF;
            if (safe[b] || b == 58 && i3 < validColonPrefixLen) {
                encodedPath.append((char)b);
                continue;
            }
            encodedPath.append('%');
            encodedPath.append(HEXADECIMAL[(b & 0xF0) >> 4]);
            encodedPath.append(HEXADECIMAL[b & 0xF]);
        }
        return encodedPath.toString();
    }

    public static String normalizeURLPath(String urlPath) {
        String urlPathNormalized = urlPath;
        if (!(urlPathNormalized.startsWith("jrt:") || urlPathNormalized.startsWith("http://") || urlPathNormalized.startsWith("https://"))) {
            if (urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = urlPathNormalized.substring(4);
            }
            if (urlPathNormalized.startsWith("file:")) {
                urlPathNormalized = urlPathNormalized.substring(4);
            }
            String windowsDrivePrefix = "";
            if (VersionFinder.OS == VersionFinder.OperatingSystem.Windows) {
                if (urlPathNormalized.length() >= 2 && Character.isLetter(urlPathNormalized.charAt(0)) && urlPathNormalized.charAt(1) == ':') {
                    windowsDrivePrefix = urlPathNormalized.substring(0, 2);
                    urlPathNormalized = urlPathNormalized.substring(2);
                } else if (urlPathNormalized.length() >= 3 && urlPathNormalized.charAt(0) == '/' && Character.isLetter(urlPathNormalized.charAt(1)) && urlPathNormalized.charAt(2) == ':') {
                    windowsDrivePrefix = urlPathNormalized.substring(1, 3);
                    urlPathNormalized = urlPathNormalized.substring(3);
                }
            }
            urlPathNormalized = urlPathNormalized.replace("/!", "!").replace("!/", "!").replace("!", "!/");
            urlPathNormalized = windowsDrivePrefix.isEmpty() ? (urlPathNormalized.startsWith("/") ? "file:" + urlPathNormalized : "file:/" + urlPathNormalized) : "file:/" + windowsDrivePrefix + (urlPathNormalized.startsWith("/") ? urlPathNormalized : "/" + urlPathNormalized);
            if (urlPathNormalized.contains("!") && !urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = "jar:" + urlPathNormalized;
            }
        }
        return URLPathEncoder.encodePath(urlPathNormalized);
    }

    static {
        int i2;
        safe = new boolean[256];
        for (i2 = 97; i2 <= 122; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        URLPathEncoder.safe[43] = true;
        URLPathEncoder.safe[46] = true;
        URLPathEncoder.safe[95] = true;
        URLPathEncoder.safe[45] = true;
        URLPathEncoder.safe[36] = true;
        URLPathEncoder.safe[44] = true;
        URLPathEncoder.safe[41] = true;
        URLPathEncoder.safe[40] = true;
        URLPathEncoder.safe[39] = true;
        URLPathEncoder.safe[42] = true;
        URLPathEncoder.safe[33] = true;
        URLPathEncoder.safe[47] = true;
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        SCHEME_PREFIXES = new String[]{"jrt:", "file:", "jar:file:", "jar:", "http:", "https:"};
    }
}

