/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.Resource;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.Scanner;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.WorkQueue;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.JarUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
abstract class ClasspathElement {
    int classpathElementIdx;
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    boolean containsSpecificallyAcceptedClasspathElementResourcePath;
    final Queue<Map.Entry<Integer, ClasspathElement>> childClasspathElementsIndexed = new ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>>();
    List<ClasspathElement> childClasspathElementsOrdered;
    protected final List<Resource> acceptedResources = new ArrayList<Resource>();
    protected List<Resource> acceptedClassfileResources = new ArrayList<Resource>();
    protected final Map<File, Long> fileToLastModified = new ConcurrentHashMap<File, Long>();
    protected final AtomicBoolean scanned = new AtomicBoolean(false);
    protected ClassLoader classLoader;
    String moduleNameFromModuleDescriptor;
    final ScanSpec scanSpec;

    ClasspathElement(ClassLoader classLoader, ScanSpec scanSpec) {
        this.classLoader = classLoader;
        this.scanSpec = scanSpec;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    int getNumClassfileMatches() {
        return this.acceptedClassfileResources == null ? 0 : this.acceptedClassfileResources.size();
    }

    protected void checkResourcePathAcceptReject(String relativePath, LogNode log) {
        if (!this.scanSpec.classpathElementResourcePathAcceptReject.acceptAndRejectAreEmpty()) {
            if (this.scanSpec.classpathElementResourcePathAcceptReject.isRejected(relativePath)) {
                if (log != null) {
                    log.log("Reached rejected classpath element resource path, stopping scanning: " + relativePath);
                }
                this.skipClasspathElement = true;
                return;
            }
            if (this.scanSpec.classpathElementResourcePathAcceptReject.isSpecificallyAccepted(relativePath)) {
                if (log != null) {
                    log.log("Reached specifically accepted classpath element resource path: " + relativePath);
                }
                this.containsSpecificallyAcceptedClasspathElementResourcePath = true;
            }
        }
    }

    void maskClassfiles(int classpathIdx, Set<String> classpathRelativePathsFound, LogNode log) {
        ArrayList<Resource> acceptedClassfileResourcesFiltered = new ArrayList<Resource>(this.acceptedClassfileResources.size());
        boolean foundMasked = false;
        for (Resource res : this.acceptedClassfileResources) {
            String pathRelativeToPackageRoot = res.getPath();
            if (!(pathRelativeToPackageRoot.equals("module-info.class") || pathRelativeToPackageRoot.equals("package-info.class") || pathRelativeToPackageRoot.endsWith("/package-info.class") || classpathRelativePathsFound.add(pathRelativeToPackageRoot))) {
                foundMasked = true;
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + JarUtils.classfilePathToClassName(pathRelativeToPackageRoot) + " found at " + res);
                continue;
            }
            acceptedClassfileResourcesFiltered.add(res);
        }
        if (foundMasked) {
            this.acceptedClassfileResources = acceptedClassfileResourcesFiltered;
        }
    }

    protected void addAcceptedResource(Resource resource2, ScanSpec.ScanSpecPathMatch parentMatchStatus, boolean isClassfileOnly, LogNode log) {
        String path = resource2.getPath();
        boolean isClassFile = FileUtils.isClassfile(path);
        boolean isAccepted = false;
        if (isClassFile) {
            if (this.scanSpec.enableClassInfo && !this.scanSpec.classfilePathAcceptReject.isRejected(path)) {
                this.acceptedClassfileResources.add(resource2);
                isAccepted = true;
            }
        } else {
            isAccepted = true;
        }
        if (!isClassfileOnly) {
            this.acceptedResources.add(resource2);
        }
        if (log != null && isAccepted) {
            String logStr;
            String type = isClassFile ? "classfile" : "resource";
            switch (parentMatchStatus) {
                case HAS_ACCEPTED_PATH_PREFIX: {
                    logStr = "Found " + type + " within subpackage of accepted package: ";
                    break;
                }
                case AT_ACCEPTED_PATH: {
                    logStr = "Found " + type + " within accepted package: ";
                    break;
                }
                case AT_ACCEPTED_CLASS_PACKAGE: {
                    logStr = "Found specifically-accepted " + type + ": ";
                    break;
                }
                default: {
                    logStr = "Found accepted " + type + ": ";
                }
            }
            resource2.scanLog = log.log("0:" + path, logStr + path + (path.equals(resource2.getPathRelativeToClasspathElement()) ? "" : " ; full path: " + resource2.getPathRelativeToClasspathElement()));
        }
    }

    protected void finishScanPaths(LogNode log) {
        if (log != null) {
            if (this.acceptedResources.isEmpty() && this.acceptedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No accepted classfiles or resources found" : "Classfile scanning is disabled, and no accepted resources found");
            } else if (this.acceptedResources.isEmpty()) {
                log.log("No accepted resources found");
            } else if (this.acceptedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No accepted classfiles found" : "Classfile scanning is disabled");
            }
        }
        if (log != null) {
            log.addElapsedTime();
        }
    }

    protected LogNode log(int classpathElementIdx, String msg, LogNode log) {
        return log.log(String.format("%07d", classpathElementIdx), msg);
    }

    abstract void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> var1, LogNode var2) throws InterruptedException;

    abstract void scanPaths(LogNode var1);

    abstract Resource getResource(String var1);

    abstract URI getURI();

    abstract File getFile();

    abstract String getModuleName();
}

