/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonInclude;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JavaType;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.util.ClassUtil;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class BeanUtil {
    @Deprecated
    public static String okNameForGetter(AnnotatedMethod am, boolean stdNaming) {
        String name = am.getName();
        String str = BeanUtil.okNameForIsGetter(am, name, stdNaming);
        if (str == null) {
            str = BeanUtil.okNameForRegularGetter(am, name, stdNaming);
        }
        return str;
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod am, String name, boolean stdNaming) {
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) ? BeanUtil.isCglibGetCallbacks(am) : "getMetaClass".equals(name) && BeanUtil.isGroovyMetaClassGetter(am)) {
                return null;
            }
            return stdNaming ? BeanUtil.stdManglePropertyName(name, 3) : BeanUtil.legacyManglePropertyName(name, 3);
        }
        return null;
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod am, String name, boolean stdNaming) {
        Class<?> rt;
        if (name.startsWith("is") && ((rt = am.getRawType()) == Boolean.class || rt == Boolean.TYPE)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name, 2) : BeanUtil.legacyManglePropertyName(name, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod am, boolean stdNaming) {
        return BeanUtil.okNameForMutator(am, "set", stdNaming);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod am, String prefix, boolean stdNaming) {
        String name = am.getName();
        if (name.startsWith(prefix)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name, prefix.length()) : BeanUtil.legacyManglePropertyName(name, prefix.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType type) {
        Class<?> cls = type.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type.isContainerType() || type.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(0L);
            return c;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod am) {
        Class<?> compType;
        String className;
        Class<?> rt = am.getRawType();
        if (rt.isArray() && (className = (compType = rt.getComponentType()).getName()).contains(".cglib")) {
            return className.startsWith("net.sf.cglib") || className.startsWith("org.hibernate.repackage.cglib") || className.startsWith("org.springframework.cglib");
        }
        return false;
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod am) {
        return am.getRawType().getName().startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String basename, int offset) {
        char d;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c = basename.charAt(offset);
        if (c == (d = Character.toLowerCase(c))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(d);
        for (int i2 = offset + 1; i2 < end; ++i2) {
            c = basename.charAt(i2);
            if (c == (d = Character.toLowerCase(c))) {
                sb.append(basename, i2, end);
                break;
            }
            sb.append(d);
        }
        return sb.toString();
    }

    public static String stdManglePropertyName(String basename, int offset) {
        char c1;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }

    public static String checkUnsupportedType(JavaType type) {
        String moduleName2;
        String typeName;
        Class<?> rawType = type.getRawClass();
        if (BeanUtil.isJava8TimeClass(rawType)) {
            typeName = "Java 8 date/time";
            moduleName2 = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(rawType)) {
            typeName = "Joda date/time";
            moduleName2 = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", typeName, ClassUtil.getTypeDescription(type), moduleName2);
    }

    public static boolean isJava8TimeClass(Class<?> rawType) {
        return rawType.getName().startsWith("java.time.");
    }

    public static boolean isJodaTimeClass(Class<?> rawType) {
        return rawType.getName().startsWith("org.joda.time.");
    }
}

