/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import name.remal.Services;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonFactory;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectMapper;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.JsonFactoryConfigurer;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.ObjectMapperConfigurer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class Utils {
    private static final List<JsonFactoryConfigurer> JSON_FACTORY_CONFIGURERS = Services.loadServicesList(JsonFactoryConfigurer.class);
    private static final List<ObjectMapperConfigurer> OBJECT_MAPPER_CONFIGURERS = Services.loadServicesList(ObjectMapperConfigurer.class);

    @NotNull
    public static <T extends JsonFactory> T configure(@NotNull T jsonFactory) {
        for (JsonFactoryConfigurer configurer : JSON_FACTORY_CONFIGURERS) {
            configurer.configure(jsonFactory);
        }
        return jsonFactory;
    }

    @NotNull
    public static <T extends ObjectMapper> T configure(@NotNull T objectMapper) {
        for (ObjectMapperConfigurer configurer : OBJECT_MAPPER_CONFIGURERS) {
            configurer.configure(objectMapper);
        }
        return objectMapper;
    }

    public static boolean isClassExists(@NotNull ClassLoader classLoader, @NotNull String className) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }
}

