/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.internal.configurers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.TimeZone;
import name.remal.Services;
import name.remal.gradle_plugins.api.AutoService;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonInclude;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.DeserializationFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.MapperFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.Module;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectMapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationFeature;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.ModuleCondition;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.ObjectMapperConfigurer;
import name.remal.log.LogUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@AutoService(value={ObjectMapperConfigurer.class})
public class DefaultObjectMapperConfigurer
implements ObjectMapperConfigurer {
    private static final ClassLoader CLASS_LOADER = DefaultObjectMapperConfigurer.class.getClassLoader();
    private static final Collection<String> PRIORITIZED_MODULE_CLASSES = Collections.singletonList("name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule");
    private static final List<ModuleCondition> MODULE_CONDITIONS = Services.loadServicesList(ModuleCondition.class);

    @Override
    public void configure(@NotNull ObjectMapper objectMapper) {
        objectMapper.enable(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        objectMapper.enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        objectMapper.enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        objectMapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        objectMapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, objectMapper.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS));
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        this.loadModules(objectMapper);
    }

    private void loadModules(@NotNull ObjectMapper objectMapper) {
        for (String moduleClassName : PRIORITIZED_MODULE_CLASSES) {
            try {
                Class<?> javaTimeModuleClass = CLASS_LOADER.loadClass(moduleClassName);
                Module javaTimeModule = (Module)javaTimeModuleClass.newInstance();
                LogUtils.logDebug(this.getClass(), (String)("Loading module: " + javaTimeModule.getClass().getName()));
                this.loadModule(objectMapper, javaTimeModule);
            }
            catch (ClassNotFoundException | LinkageError javaTimeModuleClass) {
            }
            catch (Throwable throwable) {
                LogUtils.logError(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
            }
        }
        Iterator modulesIterator = Services.loadServices(Module.class, (ClassLoader)CLASS_LOADER).iterator();
        while (true) {
            try {
                while (modulesIterator.hasNext()) {
                    Module module2 = (Module)modulesIterator.next();
                    LogUtils.logDebug(this.getClass(), (String)("Loading module: " + module2.getClass().getName()));
                    this.loadModule(objectMapper, module2);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof LinkageError || throwable instanceof ClassNotFoundException || throwable instanceof ServiceConfigurationError) {
                    LogUtils.logDebug(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
                    continue;
                }
                LogUtils.logError(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
                continue;
            }
            break;
        }
    }

    private void loadModule(@NotNull ObjectMapper objectMapper, @NotNull Module module2) {
        try {
            boolean canBeRegistered = true;
            for (ModuleCondition moduleCondition : MODULE_CONDITIONS) {
                if (moduleCondition.canModuleBeRegistered(module2)) continue;
                canBeRegistered = false;
                break;
            }
            if (canBeRegistered) {
                objectMapper.registerModule(module2);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof LinkageError || throwable instanceof ClassNotFoundException || throwable instanceof ServiceConfigurationError) {
                LogUtils.logDebug(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
            }
            LogUtils.logError(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
        }
    }
}

