/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonGenerator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.BeanProperty;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonMappingException;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.MapperFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationConfig;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializerProvider;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.PropertyFilter;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class AnyGetterWriter {
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanProperty property, AnnotatedMember accessor, JsonSerializer<?> serializer) {
        this._accessor = accessor;
        this._property = property;
        this._serializer = serializer;
        if (serializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)serializer;
        }
    }

    public void fixAccess(SerializationConfig config) {
        this._accessor.fixAccess(config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' %s() not java.util.Map but %s", this._accessor.getName(), value.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeWithoutTypeInfo((Map)value, gen, provider);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void getAndFilter(Object bean, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter2) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' (%s()) not java.util.Map but %s", this._accessor.getName(), value.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredAnyProperties(provider, gen, bean, (Map)value, filter2, null);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            JsonSerializer<?> ser = provider.handlePrimaryContextualization(this._serializer, this._property);
            this._serializer = ser;
            if (ser instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)ser;
            }
        }
    }
}

