/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class NameTransformer {
    public static final NameTransformer NOP = new NopTransformer();

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(final String prefix, final String suffix) {
        boolean hasSuffix;
        boolean hasPrefix = prefix != null && !prefix.isEmpty();
        boolean bl = hasSuffix = suffix != null && !suffix.isEmpty();
        if (hasPrefix) {
            if (hasSuffix) {
                return new NameTransformer(){

                    @Override
                    public String transform(String name) {
                        return prefix + name + suffix;
                    }

                    @Override
                    public String reverse(String transformed) {
                        String str;
                        if (transformed.startsWith(prefix) && (str = transformed.substring(prefix.length())).endsWith(suffix)) {
                            return str.substring(0, str.length() - suffix.length());
                        }
                        return null;
                    }

                    public String toString() {
                        return "[PreAndSuffixTransformer('" + prefix + "','" + suffix + "')]";
                    }
                };
            }
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return prefix + name;
                }

                @Override
                public String reverse(String transformed) {
                    if (transformed.startsWith(prefix)) {
                        return transformed.substring(prefix.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[PrefixTransformer('" + prefix + "')]";
                }
            };
        }
        if (hasSuffix) {
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return name + suffix;
                }

                @Override
                public String reverse(String transformed) {
                    if (transformed.endsWith(suffix)) {
                        return transformed.substring(0, transformed.length() - suffix.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[SuffixTransformer('" + suffix + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer t1, NameTransformer t2) {
        return new Chained(t1, t2);
    }

    public abstract String transform(String var1);

    public abstract String reverse(String var1);

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    public static class Chained
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer t1, NameTransformer t2) {
            this._t1 = t1;
            this._t2 = t2;
        }

        @Override
        public String transform(String name) {
            return this._t1.transform(this._t2.transform(name));
        }

        @Override
        public String reverse(String transformed) {
            if ((transformed = this._t1.reverse(transformed)) != null) {
                transformed = this._t2.reverse(transformed);
            }
            return transformed;
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    protected static final class NopTransformer
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected NopTransformer() {
        }

        @Override
        public String transform(String name) {
            return name;
        }

        @Override
        public String reverse(String transformed) {
            return transformed;
        }
    }
}

