/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.google.common.annotations.Beta;
import name.remal.gradle_plugins.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins.internal._relocated.com.google.common.annotations.GwtIncompatible;
import name.remal.gradle_plugins.internal._relocated.com.google.common.base.Preconditions;
import name.remal.gradle_plugins.internal._relocated.com.google.common.base.Supplier;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.AsyncCallable;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.ListeningExecutorService;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.ParametricNullness;
import org.jetbrains.annotations.ApiStatus;

@ElementTypesAreNonnullByDefault
@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T value) {
        return () -> value;
    }

    @Beta
    @GwtIncompatible
    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return () -> listeningExecutorService.submit(callable);
    }

    @GwtIncompatible
    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @GwtIncompatible
    static Runnable threadRenaming(Runnable task, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                task.run();
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @GwtIncompatible
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

