/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.google.common.annotations.GwtIncompatible;
import name.remal.gradle_plugins.internal._relocated.com.google.common.base.Preconditions;
import name.remal.gradle_plugins.internal._relocated.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.jetbrains.annotations.ApiStatus;

@ElementTypesAreNonnullByDefault
@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtIncompatible
public final class ExecutionList {
    private static final Logger log = Logger.getLogger(ExecutionList.class.getName());
    @CheckForNull
    @GuardedBy(value="this")
    private RunnableExecutorPair runnables;
    @GuardedBy(value="this")
    private boolean executed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (!this.executed) {
                this.runnables = new RunnableExecutorPair(runnable, executor, this.runnables);
                return;
            }
        }
        ExecutionList.executeListener(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        RunnableExecutorPair list;
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            list = this.runnables;
            this.runnables = null;
        }
        RunnableExecutorPair reversedList = null;
        while (list != null) {
            RunnableExecutorPair tmp = list;
            list = list.next;
            tmp.next = reversedList;
            reversedList = tmp;
        }
        while (reversedList != null) {
            ExecutionList.executeListener(reversedList.runnable, reversedList.executor);
            reversedList = reversedList.next;
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException e) {
            String string = String.valueOf(runnable);
            String string2 = String.valueOf(executor);
            log.log(Level.SEVERE, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RuntimeException while executing runnable ").append(string).append(" with executor ").append(string2).toString(), e);
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;
        @CheckForNull
        RunnableExecutorPair next;

        RunnableExecutorPair(Runnable runnable, Executor executor, @CheckForNull RunnableExecutorPair next) {
            this.runnable = runnable;
            this.executor = executor;
            this.next = next;
        }
    }
}

