/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import name.remal.gradle_plugins.dsl.Extension;
import name.remal.gradle_plugins.dsl.ExtensionProperty;
import org.jetbrains.annotations.NotNull;

@Extension(value="Filtering settings for copy tasks")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u00178\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lname/remal/gradle_plugins/plugins/common/FilteringSettings;", "", "()V", "beginToken", "", "getBeginToken", "()Ljava/lang/String;", "setBeginToken", "(Ljava/lang/String;)V", "endToken", "getEndToken", "setEndToken", "value", "", "fileExtensions", "getFileExtensions", "()Ljava/util/Set;", "setFileExtensions", "(Ljava/util/Set;)V", "filePatterns", "getFilePatterns", "setFilePatterns", "filteringCharset", "Ljava/nio/charset/Charset;", "getFilteringCharset", "()Ljava/nio/charset/Charset;", "setFilteringCharset", "(Ljava/nio/charset/Charset;)V", "gradle-plugins"})
public class FilteringSettings {
    @ExtensionProperty(value="Specifies extensions of files to do filtering")
    @NotNull
    private Set<String> fileExtensions = SetsKt.sortedSetOf((Object[])new String[]{"properties", "xml"});
    @ExtensionProperty(value="Specifies file patterns to do filtering")
    @NotNull
    private Set<String> filePatterns = SetsKt.sortedSetOf((Object[])new String[0]);
    @ExtensionProperty(value="Specifies the charset used to read and write files when filtering")
    @NotNull
    private Charset filteringCharset;
    @ExtensionProperty(value="Specifies the \"begin token\"")
    @NotNull
    private String beginToken;
    @ExtensionProperty(value="Specifies the \"end token\"")
    @NotNull
    private String endToken;

    @NotNull
    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(@NotNull Set<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.fileExtensions = CollectionsKt.toSortedSet((Iterable)value);
    }

    @NotNull
    public Set<String> getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(@NotNull Set<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.filePatterns = CollectionsKt.toSortedSet((Iterable)value);
    }

    @NotNull
    public Charset getFilteringCharset() {
        return this.filteringCharset;
    }

    public void setFilteringCharset(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.filteringCharset = charset;
    }

    @NotNull
    public String getBeginToken() {
        return this.beginToken;
    }

    public void setBeginToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.beginToken = string;
    }

    @NotNull
    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.endToken = string;
    }

    public FilteringSettings() {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        this.filteringCharset = charset;
        this.beginToken = "@";
        this.endToken = "@";
    }
}

