/*
 * Decompiled with CFR 0.152.
 */
package name.remal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import name.remal.log.LogUtils;
import name.remal.tools.common.internal._relocated.kr.motd.maven.os.Detector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OS {
    @NotNull
    public static String getOsName() {
        return Objects.requireNonNull(PropertiesHolder.PROPERTIES.getProperty("os.detected.name"), "os.detected.name is not set");
    }

    @NotNull
    public static String getOsArch() {
        return Objects.requireNonNull(PropertiesHolder.PROPERTIES.getProperty("os.detected.arch"), "os.detected.arch is not set");
    }

    @NotNull
    public static String getOsClassifier() {
        return Objects.requireNonNull(PropertiesHolder.PROPERTIES.getProperty("os.detected.classifier"), "os.detected.classifier is not set");
    }

    @Nullable
    public static String getOsVersion() {
        return PropertiesHolder.PROPERTIES.getProperty("os.detected.version");
    }

    public static boolean isAix() {
        return "aix".equals(OS.getOsName());
    }

    public static boolean isHpux() {
        return "hpux".equals(OS.getOsName());
    }

    public static boolean isOs400() {
        return "os400".equals(OS.getOsName());
    }

    public static boolean isLinux() {
        return "linux".equals(OS.getOsName());
    }

    public static boolean isOsx() {
        return "osx".equals(OS.getOsName());
    }

    public static boolean isFreebsd() {
        return "freebsd".equals(OS.getOsName());
    }

    public static boolean isOpenbsd() {
        return "openbsd".equals(OS.getOsName());
    }

    public static boolean isNetbsd() {
        return "netbsd".equals(OS.getOsName());
    }

    public static boolean isSunos() {
        return "sunos".equals(OS.getOsName());
    }

    public static boolean isWindows() {
        return "windows".equals(OS.getOsName());
    }

    public static boolean isZos() {
        return "zos".equals(OS.getOsName());
    }

    private OS() {
    }

    private static class DetectorImpl
    extends Detector {
        private DetectorImpl() {
        }

        @Override
        public void detect(@NotNull Properties props, @NotNull List<String> classifierWithLikes) {
            super.detect(props, classifierWithLikes);
        }

        @Override
        protected void log(String message) {
            LogUtils.logDebug(OS.class, message);
        }

        @Override
        protected void logProperty(String name, String value) {
            LogUtils.logDebug(OS.class, name + " = " + value);
        }
    }

    private static class PropertiesHolder {
        private static final Properties PROPERTIES = new Properties();

        private PropertiesHolder() {
        }

        static {
            new DetectorImpl().detect(PROPERTIES, Collections.emptyList());
            new ArrayList<Map.Entry<Object, Object>>(PROPERTIES.entrySet()).forEach((Consumer<Map.Entry<Object, Object>>)((Consumer<Map.Entry>)entry -> {
                if (entry.getKey().toString().isEmpty() || entry.getValue().toString().isEmpty()) {
                    PROPERTIES.remove(entry.getKey());
                }
            }));
        }
    }
}

