/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.Objects;
import name.remal.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AnnotationAttribute {
    @NotNull
    private final Class<? extends Annotation> annotationType;
    @NotNull
    private final String name;
    @Nullable
    private final Object value;

    public AnnotationAttribute(@NotNull Class<? extends Annotation> annotationType, @NotNull String name, @Nullable Object value) {
        this.annotationType = annotationType;
        this.name = name;
        this.value = value;
    }

    @NotNull
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AnnotationAttribute)) {
            return false;
        }
        AnnotationAttribute other = (AnnotationAttribute)object;
        return Objects.equals(this.annotationType, other.annotationType) && Objects.equals(this.name, other.name) && ArrayUtils.arrayEquals(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.annotationType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ArrayUtils.arrayHashCode(this.value);
        return result;
    }

    @NotNull
    public String toString() {
        return AnnotationAttribute.class.getSimpleName() + '(' + "annotationType=" + this.annotationType + ", name='" + this.name + '\'' + ", value=" + ArrayUtils.arrayToString(this.value) + '}';
    }

    @SuppressFBWarnings
    protected /* synthetic */ AnnotationAttribute() {
    }
}

