/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Arrays;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationAnnotationValue;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class BytecodeAnnotationAnnotationsArrayValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final BytecodeAnnotationAnnotationValue[] EMPTY = new BytecodeAnnotationAnnotationValue[0];
    private static final long serialVersionUID = 1L;
    @NotNull
    private BytecodeAnnotationAnnotationValue[] value = EMPTY;

    public BytecodeAnnotationAnnotationsArrayValue() {
    }

    @Contract(value="null->fail")
    public BytecodeAnnotationAnnotationsArrayValue(BytecodeAnnotationAnnotationValue ... value) {
        Objects.requireNonNull(value);
        for (int i = 0; i < value.length; ++i) {
            Objects.requireNonNull(value[i], "value[" + i + ']');
        }
        this.value = value;
    }

    @NotNull
    public BytecodeAnnotationAnnotationValue[] getValue() {
        return this.value;
    }

    @Contract(value="null->fail")
    public void setValue(@NotNull BytecodeAnnotationAnnotationValue[] value) {
        Objects.requireNonNull(value);
        for (int i = 0; i < value.length; ++i) {
            Objects.requireNonNull(value[i], "value[" + i + ']');
        }
        this.value = value;
    }

    @NotNull
    @Contract(value="null->fail")
    public BytecodeAnnotationAnnotationsArrayValue addItem(@NotNull BytecodeAnnotationAnnotationValue item) {
        BytecodeAnnotationAnnotationValue[] newValue = new BytecodeAnnotationAnnotationValue[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = Objects.requireNonNull(item);
        this.value = newValue;
        return this;
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationAnnotationsArrayValue)) {
            return false;
        }
        BytecodeAnnotationAnnotationsArrayValue that = (BytecodeAnnotationAnnotationsArrayValue)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValue());
    }

    @Override
    public boolean isAnnotationsArray() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationAnnotationsArrayValue asAnnotationsArray() {
        return this;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.value == null) {
            throw new InvalidObjectException("value is null");
        }
        for (int i = 0; i < this.value.length; ++i) {
            Objects.requireNonNull(this.value[i], "value[" + i + ']');
            try {
                this.value[i].validateObject();
                continue;
            }
            catch (InvalidObjectException e) {
                throw new InvalidObjectException("value[" + i + "]: " + e.getMessage());
            }
        }
    }
}

