/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnnotationClassValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String className;

    @Contract(value="null->fail")
    public BytecodeAnnotationClassValue(@NotNull String className) {
        this.className = Objects.requireNonNull(className);
    }

    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Contract(value="null->fail")
    public void setClassName(@NotNull String className) {
        this.className = Objects.requireNonNull(className);
    }

    @NotNull
    public String toString() {
        return this.className;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationClassValue)) {
            return false;
        }
        BytecodeAnnotationClassValue that = (BytecodeAnnotationClassValue)o;
        return this.className.equals(that.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationClassValue asClass() {
        return this;
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    private BytecodeAnnotationClassValue() {
        this.className = null;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.className == null) {
            throw new InvalidObjectException("className is null");
        }
    }
}

