/*
 * Decompiled with CFR 0.152.
 */
package name.remal.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import name.remal.ArrayUtils;
import name.remal.annotation.AnnotationUtils;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public class AsmUtils {
    public static final int ASM_API;

    @NotNull
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public static Object fromJavaToBytecodeAnnotationValue(@NotNull Object value) {
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Character) {
            return value;
        }
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Type) {
            return value;
        }
        if (value instanceof Class) {
            return Type.getType((Class)((Class)value));
        }
        if (value instanceof String[]) {
            String[] typedValue = (String[])value;
            if (2 != typedValue.length || null == typedValue[0] || null == typedValue[1]) {
                throw new IllegalArgumentException("Unsupported enum value: " + ArrayUtils.arrayToString(typedValue));
            }
            return value;
        }
        if (value instanceof Enum) {
            Enum typedValue = (Enum)value;
            return new String[]{Type.getDescriptor(typedValue.getDeclaringClass()), typedValue.name()};
        }
        if (value instanceof AnnotationNode) {
            return value;
        }
        if (value instanceof Annotation) {
            Annotation typedValue = (Annotation)value;
            AnnotationNode annotationNode = new AnnotationNode(Type.getDescriptor(typedValue.annotationType()));
            annotationNode.values = new ArrayList();
            AnnotationUtils.getAttributes(typedValue).forEach((fieldName, fieldValue) -> {
                annotationNode.values.add(fieldName);
                annotationNode.values.add(AsmUtils.fromJavaToBytecodeAnnotationValue(fieldValue));
            });
            return annotationNode;
        }
        if (value instanceof List) {
            List typedValue = (List)value;
            ArrayList<Object> resultList = new ArrayList<Object>(typedValue.size());
            for (Object element : typedValue) {
                if (element instanceof List) {
                    throw new IllegalArgumentException("Unsupported annotation value: " + ArrayUtils.arrayToString(value));
                }
                resultList.add(AsmUtils.fromJavaToBytecodeAnnotationValue(element));
            }
            return resultList;
        }
        throw new IllegalArgumentException("Unsupported annotation value: " + value.getClass() + ": " + ArrayUtils.arrayToString(value));
    }

    static {
        try {
            ClassWriter classWriter = new ClassWriter(0);
            Field apiField = ClassVisitor.class.getDeclaredField("api");
            apiField.setAccessible(true);
            ASM_API = apiField.getInt(classWriter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

