/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import name.remal.SneakyThrow;
import name.remal.UncheckedCast;
import name.remal.lambda.Function1;
import name.remal.lambda.VoidFunction1;
import name.remal.reflection.ExtendedURLClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLoaderUtils {
    private static final Method ADD_URL_METHOD;

    @Nullable
    public static Package getPackageOrNull(@NotNull ClassLoader classLoader, @NotNull String packageName) {
        return new ClassLoaderWrapper(classLoader).getPackageOrNull(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"squid:S2445"})
    public static void addURLsToClassLoader(@NotNull ClassLoader classLoader, URL ... urls) {
        if (0 == urls.length) {
            return;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        while (true) {
            if (classLoader instanceof URLClassLoader) {
                ClassLoader classLoader2 = classLoader;
                synchronized (classLoader2) {
                    for (URL url : urls) {
                        try {
                            ADD_URL_METHOD.invoke((Object)classLoader, url);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw SneakyThrow.sneakyThrow(e);
                        }
                    }
                }
                return;
            }
            if (systemClassLoader == classLoader) break;
            if ((classLoader = classLoader.getParent()) != null) continue;
            classLoader = systemClassLoader;
        }
        throw new IllegalStateException("New URL can't be added to system ClassLoader: " + systemClassLoader);
    }

    public static <T, R> R forInstantiated(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull Function1<R, T> action) {
        return ClassLoaderUtils.forInstantiated(classLoader, type, implementationType, new InstantiatedClassesPropagation(), action);
    }

    public static <T> void forInstantiated(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull VoidFunction1<T> action) {
        ClassLoaderUtils.forInstantiated(classLoader, type, implementationType, (T it) -> {
            action.invoke(it);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R forInstantiated(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull InstantiatedClassesPropagation propagation, @NotNull Function1<R, T> action) {
        if (!type.isAssignableFrom(implementationType) || type == implementationType) {
            throw new IllegalArgumentException(implementationType + " is not subtype of " + type);
        }
        propagation.addClassName(implementationType);
        List<String> propagatedClassInternalNames = propagation.getClassInternalNames();
        List<String> propagatedPackageInternalNames = propagation.getPackageInternalNames();
        URL sourceURL = Optional.ofNullable(implementationType.getProtectionDomain()).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).orElseThrow(() -> new IllegalStateException(implementationType + ": protectionDomain?.codeSource?.location == null"));
        try {
            Throwable throwable = null;
            try (ExtendedURLClassLoader childClassLoader = new ExtendedURLClassLoader(resourceName -> {
                for (String propagatedPackageInternalName : propagatedPackageInternalNames) {
                    if (!resourceName.startsWith(propagatedPackageInternalName + '/')) continue;
                    return ExtendedURLClassLoader.LoadingOrder.THIS_ONLY;
                }
                for (String propagatedClassInternalName : propagatedClassInternalNames) {
                    if (!resourceName.equals(propagatedClassInternalName + ".class") && (!resourceName.startsWith(propagatedClassInternalName + '$') || !resourceName.endsWith(".class"))) continue;
                    return ExtendedURLClassLoader.LoadingOrder.THIS_ONLY;
                }
                return ExtendedURLClassLoader.LoadingOrder.PARENT_ONLY;
            }, new URL[]{sourceURL}, classLoader);){
                R r;
                Thread currentThread = Thread.currentThread();
                ClassLoader prevContextClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(classLoader);
                try {
                    Object implementation = UncheckedCast.uncheckedCast(((ClassLoader)childClassLoader).loadClass(implementationType.getName()).newInstance());
                    r = action.invoke(implementation);
                    currentThread.setContextClassLoader(prevContextClassLoader);
                }
                catch (Throwable throwable2) {
                    try {
                        currentThread.setContextClassLoader(prevContextClassLoader);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                return r;
            }
        }
        catch (Throwable e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    public static <T> void forInstantiated(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull InstantiatedClassesPropagation propagation, @NotNull VoidFunction1<T> action) {
        ClassLoaderUtils.forInstantiated(classLoader, type, implementationType, propagation, (T it) -> {
            action.invoke(it);
            return null;
        });
    }

    public static <T, R> R forInstantiatedWithPropagatedPackage(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull Function1<R, T> action) {
        return ClassLoaderUtils.forInstantiated(classLoader, type, implementationType, new InstantiatedClassesPropagation().addPackageName(implementationType), action);
    }

    public static <T> void forInstantiatedWithPropagatedPackage(@Nullable ClassLoader classLoader, @NotNull Class<T> type, @NotNull Class<? extends T> implementationType, @NotNull VoidFunction1<T> action) {
        ClassLoaderUtils.forInstantiatedWithPropagatedPackage(classLoader, type, implementationType, (T it) -> {
            action.invoke(it);
            return null;
        });
    }

    static {
        try {
            ADD_URL_METHOD = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    public static class InstantiatedClassesPropagation {
        @NotNull
        private final @NotNull Set<@NotNull String> classInternalNames = new TreeSet<String>();
        @NotNull
        private final @NotNull Set<@NotNull String> packageInternalNames = new TreeSet<String>();

        @NotNull
        public @NotNull List<@NotNull String> getClassInternalNames() {
            return new ArrayList<String>(this.classInternalNames);
        }

        @NotNull
        public InstantiatedClassesPropagation addClassName(@NotNull String className) {
            this.classInternalNames.add(className.replace('.', '/'));
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addClassNames(String ... classNames) {
            for (String className : classNames) {
                this.addClassName(className);
            }
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addClassNames(@NotNull Iterable<String> classNames) {
            for (String className : classNames) {
                this.addClassName(className);
            }
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addClassName(@NotNull Class<?> clazz) {
            return this.addClassName(clazz.getName());
        }

        @NotNull
        public InstantiatedClassesPropagation addClassNames(Class<?> ... classes) {
            for (Class<?> clazz : classes) {
                this.addClassName(clazz);
            }
            return this;
        }

        @NotNull
        public @NotNull List<@NotNull String> getPackageInternalNames() {
            return new ArrayList<String>(this.packageInternalNames);
        }

        @NotNull
        public InstantiatedClassesPropagation addPackageName(@NotNull String packageName) {
            this.packageInternalNames.add(packageName.replace('.', '/'));
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addPackageNames(String ... packageNames) {
            for (String packageName : packageNames) {
                this.addPackageName(packageName);
            }
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addPackageNames(@NotNull Iterable<String> packageNames) {
            for (String packageName : packageNames) {
                this.addPackageName(packageName);
            }
            return this;
        }

        @NotNull
        public InstantiatedClassesPropagation addPackageName(@NotNull Class<?> packageClass) {
            String packageClassName = packageClass.getName();
            return this.addPackageName(packageClassName.substring(0, Math.max(0, packageClassName.lastIndexOf(46))));
        }

        @NotNull
        public InstantiatedClassesPropagation addPackageNames(Class<?> ... packageClasses) {
            for (Class<?> packageClass : packageClasses) {
                this.addPackageName(packageClass);
            }
            return this;
        }
    }

    static class ClassLoaderWrapper
    extends ClassLoader {
        public ClassLoaderWrapper(@NotNull ClassLoader classLoader) {
            super(classLoader);
        }

        @Nullable
        public Package getPackageOrNull(@NotNull String name) {
            return this.getPackage(name);
        }

        @SuppressFBWarnings
        protected /* synthetic */ ClassLoaderWrapper() {
        }
    }
}

