/*
 * Decompiled with CFR 0.152.
 */
package name.remal.reflection;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import name.remal.ArrayUtils;
import name.remal.UncheckedCast;
import name.remal.gradle_plugins.api.RelocateClasses;
import name.remal.reflection.ClassLoaderUtils;
import name.remal.tools.common.internal._relocated.com.google.common.reflect.TypeToken;
import org.jetbrains.annotations.NotNull;

@RelocateClasses(value={TypeToken.class})
public class HierarchyUtils {
    public static int compareByHierarchySize(@NotNull Class<?> class1, @NotNull Class<?> class2) {
        return Integer.compare(HierarchyUtils.getHierarchy(class1).size(), HierarchyUtils.getHierarchy(class2).size());
    }

    @NotNull
    public static @NotNull List<@NotNull Package> getPackageHierarchy(@NotNull Class<?> clazz) {
        int lastDotPos;
        ArrayList<Package> result = new ArrayList<Package>();
        ClassLoaderUtils.ClassLoaderWrapper classLoaderWrapper = new ClassLoaderUtils.ClassLoaderWrapper(clazz.getClassLoader());
        String name = clazz.getName();
        while (0 < (lastDotPos = name.lastIndexOf(46))) {
            Package pckg = classLoaderWrapper.getPackageOrNull(name = name.substring(0, lastDotPos));
            if (pckg == null) continue;
            result.add(pckg);
        }
        return result;
    }

    @NotNull
    public static <T> @NotNull List<@NotNull Class<? super T>> getSuperClassesHierarchy(@NotNull Class<T> clazz) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Class<T> curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
            result.add(curClass);
            if (Object.class == curClass) break;
        }
        return result;
    }

    @NotNull
    public static <T> @NotNull List<@NotNull Class<? super T>> getHierarchy(@NotNull Class<T> clazz) {
        Class curClass;
        LinkedHashSet<Class> hierarchy = new LinkedHashSet<Class>();
        LinkedList queue = new LinkedList();
        queue.add(clazz);
        while ((curClass = (Class)queue.poll()) != null) {
            if (!hierarchy.add(curClass)) continue;
            Class superclass = curClass.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            for (Class<?> interfaceClass : curClass.getInterfaces()) {
                queue.add(UncheckedCast.uncheckedCast(interfaceClass));
            }
        }
        return new ArrayList<Class<? super T>>(hierarchy);
    }

    @NotNull
    public static <T> @NotNull List<@NotNull Type> getGenericHierarchy(@NotNull Class<T> clazz) {
        TypeToken<T> typeToken = TypeToken.of(clazz);
        List<Class<T>> hierarchy = HierarchyUtils.getHierarchy(clazz);
        ArrayList<Type> result = new ArrayList<Type>(hierarchy.size());
        for (Class<T> parentClass : hierarchy) {
            result.add(typeToken.getSupertype(parentClass).getType());
        }
        return result;
    }

    public static boolean canBeOverridden(@NotNull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isFinal(method.getModifiers())) {
            return false;
        }
        return !Modifier.isFinal(method.getDeclaringClass().getModifiers());
    }

    @NotNull
    public static @NotNull List<@NotNull Method> getHierarchy(@NotNull Method method) {
        if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) {
            return Collections.singletonList(method);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.getSuperclass() == null && 0 == declaringClass.getInterfaces().length) {
            return Collections.singletonList(method);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        result.add(method);
        List hierarchy = (List)UncheckedCast.uncheckedCast(HierarchyUtils.getHierarchy(declaringClass));
        List hierarchyWithoutDeclaring = hierarchy.subList(1, hierarchy.size());
        if (0 == method.getParameterCount()) {
            block0: for (Class clazz : hierarchyWithoutDeclaring) {
                for (Method curMethod : clazz.getDeclaredMethods()) {
                    if (curMethod.isSynthetic() || !HierarchyUtils.canBeOverridden(curMethod) || curMethod.getParameterCount() != method.getParameterCount() || !Objects.equals(curMethod.getName(), method.getName())) continue;
                    result.add(curMethod);
                    continue block0;
                }
            }
        } else {
            TypeToken<?> typeToken = TypeToken.of(declaringClass);
            block2: for (Class clazz : hierarchyWithoutDeclaring) {
                TypeToken<?> classTypeToken = null;
                for (Method curMethod : clazz.getDeclaredMethods()) {
                    if (curMethod.isSynthetic() || !HierarchyUtils.canBeOverridden(curMethod) || curMethod.getParameterCount() != method.getParameterCount() || !Objects.equals(curMethod.getName(), method.getName())) continue;
                    boolean areParamsMatch = true;
                    if (classTypeToken == null) {
                        classTypeToken = typeToken.getSupertype((Class)UncheckedCast.uncheckedCast(clazz));
                    }
                    for (int i = 0; i < curMethod.getParameterCount(); ++i) {
                        Type curType;
                        TypeToken<?> curTypeToken;
                        Class<?> curClass;
                        Class<?> methodClass = method.getParameterTypes()[i];
                        if (Objects.equals(methodClass, curClass = (curTypeToken = classTypeToken.resolveType(curType = curMethod.getGenericParameterTypes()[i])).getRawType())) continue;
                        areParamsMatch = false;
                        break;
                    }
                    if (!areParamsMatch) continue;
                    result.add(curMethod);
                    continue block2;
                }
            }
        }
        return result;
    }

    public static boolean isOverriddenBy(@NotNull Method parentMethod, @NotNull Method childMethod) {
        if (Objects.equals(parentMethod, childMethod)) {
            return true;
        }
        if (!HierarchyUtils.canBeOverridden(parentMethod)) {
            return false;
        }
        if (Modifier.isStatic(childMethod.getModifiers()) || Modifier.isPrivate(childMethod.getModifiers())) {
            return false;
        }
        if (parentMethod.getParameterCount() != childMethod.getParameterCount()) {
            return false;
        }
        if (!Objects.equals(parentMethod.getName(), childMethod.getName())) {
            return false;
        }
        if (!parentMethod.getDeclaringClass().isAssignableFrom(childMethod.getDeclaringClass())) {
            return false;
        }
        if (0 == parentMethod.getParameterCount()) {
            return true;
        }
        if (!HierarchyUtils.hasGenericParameters(parentMethod) && !HierarchyUtils.hasGenericParameters(childMethod)) {
            return Arrays.equals(parentMethod.getParameterTypes(), childMethod.getParameterTypes());
        }
        TypeToken<?> childTypeToken = TypeToken.of(childMethod.getDeclaringClass());
        TypeToken<?> parentTypeToken = childTypeToken.getSupertype((Class)UncheckedCast.uncheckedCast(parentMethod.getDeclaringClass()));
        for (int i = 0; i < parentMethod.getParameterCount(); ++i) {
            if (Objects.equals(childMethod.getParameterTypes()[i], parentTypeToken.resolveType(parentMethod.getGenericParameterTypes()[i]).getRawType())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasGenericParameters(@NotNull Method method) {
        for (Type type : method.getGenericParameterTypes()) {
            if (type instanceof Class) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static @NotNull List<@NotNull Parameter> getHierarchy(@NotNull Parameter parameter) {
        List<Method> hierarchy;
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        result.add(parameter);
        Executable declaringExecutable = parameter.getDeclaringExecutable();
        if (declaringExecutable instanceof Method && 2 <= (hierarchy = HierarchyUtils.getHierarchy((Method)declaringExecutable)).size()) {
            int index = ArrayUtils.indexOf(declaringExecutable.getParameters(), parameter);
            for (Method method : hierarchy.subList(1, hierarchy.size())) {
                result.add(method.getParameters()[index]);
            }
        }
        return result;
    }

    @NotNull
    public static @NotNull List<@NotNull Method> getAllNotOverriddenMethods(@NotNull Class<?> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> curClass : HierarchyUtils.getHierarchy(type)) {
            ArrayList<Method> methodsToAdd = new ArrayList<Method>();
            for (Method method : curClass.getDeclaredMethods()) {
                boolean isOverridden = false;
                if (HierarchyUtils.canBeOverridden(method)) {
                    for (Method methodToCheck : result) {
                        if (!HierarchyUtils.isOverriddenBy(method, methodToCheck)) continue;
                        isOverridden = true;
                        break;
                    }
                }
                if (isOverridden) continue;
                methodsToAdd.add(method);
            }
            result.addAll(methodsToAdd);
        }
        return result;
    }
}

