/*
 * Decompiled with CFR 0.152.
 */
package name.remal.version;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.remal.gradle_plugins.api.RelocateClasses;
import name.remal.tools.common.internal._relocated.com.google.common.base.Splitter;
import name.remal.version.VersionParsingException;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class Version
implements Comparable<Version>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final char NUMBERS_DELIMITER = '.';
    @NotNull
    private static final char[] ALLOWED_SUFFIX_DELIMITERS = new char[]{'.', '_', '-', '+'};
    @NotNull
    private static final Pattern VERSION_PATTERN;
    private static final char DEFAULT_SUFFIX_DELIMITER = '-';
    private static final Pattern SUFFIX_SPLITTER;
    private static final SuffixToken[] EMPTY_SUFFIX_TOKENS;
    @NotNull
    private static final Map<String, Integer> SUFFIX_ORDERS;
    @NotNull
    private static final Version V0;
    @NotNull
    private static final Version V1;
    @NotNull
    private static final Version V0_0;
    @NotNull
    private static final Version V0_1;
    @NotNull
    private static final Version V1_0;
    @NotNull
    private static final Version V0_0_0;
    @NotNull
    private static final Version V0_0_1;
    @NotNull
    private static final Version V0_1_0;
    @NotNull
    private static final Version V1_0_0;
    @NotNull
    private static final Version V0_0_0_0;
    @NotNull
    private static final Version V0_0_0_1;
    @NotNull
    private static final Version V0_0_1_0;
    @NotNull
    private static final Version V0_1_0_0;
    @NotNull
    private static final Version V1_0_0_0;
    @NotNull
    private final int[] numbers;
    private final char suffixDelimiter;
    @NotNull
    private final String suffix;
    @NotNull
    private final SuffixToken[] suffixTokens;
    private final int suffixOrder;
    private final long suffixSuborder;

    @NotNull
    private static Version createImpl(@NotNull int[] numbers, char suffixDelimiter, @Nullable String suffix) {
        if (suffixDelimiter == '-' && (suffix == null || suffix.isEmpty())) {
            if (Arrays.equals(Version.V0.numbers, numbers)) {
                return V0;
            }
            if (Arrays.equals(Version.V1.numbers, numbers)) {
                return V1;
            }
            if (Arrays.equals(Version.V0_0.numbers, numbers)) {
                return V0_0;
            }
            if (Arrays.equals(Version.V0_1.numbers, numbers)) {
                return V0_1;
            }
            if (Arrays.equals(Version.V1_0.numbers, numbers)) {
                return V1_0;
            }
            if (Arrays.equals(Version.V0_0_0.numbers, numbers)) {
                return V0_0_0;
            }
            if (Arrays.equals(Version.V0_0_1.numbers, numbers)) {
                return V0_0_1;
            }
            if (Arrays.equals(Version.V0_1_0.numbers, numbers)) {
                return V0_1_0;
            }
            if (Arrays.equals(Version.V1_0_0.numbers, numbers)) {
                return V1_0_0;
            }
            if (Arrays.equals(Version.V0_0_0_0.numbers, numbers)) {
                return V0_0_0_0;
            }
            if (Arrays.equals(Version.V0_0_0_1.numbers, numbers)) {
                return V0_0_0_1;
            }
            if (Arrays.equals(Version.V0_0_1_0.numbers, numbers)) {
                return V0_0_1_0;
            }
            if (Arrays.equals(Version.V0_1_0_0.numbers, numbers)) {
                return V0_1_0_0;
            }
            if (Arrays.equals(Version.V1_0_0_0.numbers, numbers)) {
                return V1_0_0_0;
            }
        }
        return new Version(numbers, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(@NotNull int[] numbers, char suffixDelimiter, @NotNull String suffix) {
        return Version.createImpl(numbers, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(@NotNull int[] numbers, @Nullable String suffix) {
        return Version.createImpl(numbers, '-', suffix);
    }

    @NotNull
    public static Version create(int ... numbers) {
        return Version.create(numbers, null);
    }

    @NotNull
    public static Version create(int major, int minor, int patch, int build2, char suffixDelimiter, @NotNull String suffix) {
        return Version.create(new int[]{major, minor, patch, build2}, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(int major, int minor, int patch, int build2, @Nullable String suffix) {
        return Version.create(new int[]{major, minor, patch, build2}, suffix);
    }

    @NotNull
    public static Version create(int major, int minor, int patch, int build2) {
        return Version.create(major, minor, patch, build2, null);
    }

    @NotNull
    public static Version create(int major, int minor, int patch, char suffixDelimiter, @NotNull String suffix) {
        return Version.create(new int[]{major, minor, patch}, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(int major, int minor, int patch, @Nullable String suffix) {
        return Version.create(new int[]{major, minor, patch}, suffix);
    }

    @NotNull
    public static Version create(int major, int minor, int patch) {
        return Version.create(major, minor, patch, null);
    }

    @NotNull
    public static Version create(int major, int minor, char suffixDelimiter, @NotNull String suffix) {
        return Version.create(new int[]{major, minor}, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(int major, int minor, @Nullable String suffix) {
        return Version.create(new int[]{major, minor}, suffix);
    }

    @NotNull
    public static Version create(int major, int minor) {
        return Version.create(major, minor, null);
    }

    @NotNull
    public static Version create(int major, char suffixDelimiter, @NotNull String suffix) {
        return Version.create(new int[]{major}, suffixDelimiter, suffix);
    }

    @NotNull
    public static Version create(int major, @Nullable String suffix) {
        return Version.create(new int[]{major}, suffix);
    }

    @NotNull
    public static Version create(int major) {
        return Version.create(major, null);
    }

    @JsonCreator
    @NotNull
    @RelocateClasses(value={Splitter.class})
    public static Version parse(@NotNull String string) throws VersionParsingException {
        if (string == null) {
            throw new VersionParsingException("NULL string");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new VersionParsingException("Empty string");
        }
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new VersionParsingException(String.format("\"%s\" doesn't match to /%s/", string, VERSION_PATTERN));
        }
        try {
            String numbersString = matcher.group(1);
            List<String> numberStrings = Splitter.on('.').splitToList(numbersString);
            int[] numbers = new int[numberStrings.size()];
            for (int i = 0; i < numbers.length; ++i) {
                numbers[i] = Integer.parseInt(numberStrings.get(i));
            }
            char suffixDelimiter = '-';
            String suffix = matcher.group(2);
            if (suffix != null && !suffix.isEmpty()) {
                suffixDelimiter = suffix.charAt(0);
                suffix = suffix.substring(1);
            }
            return Version.createImpl(numbers, suffixDelimiter, suffix);
        }
        catch (Exception e) {
            throw e instanceof VersionParsingException ? (VersionParsingException)e : new VersionParsingException(e);
        }
    }

    @Nullable
    @Contract(value="null->null")
    public static Version parseOrNull(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return Version.parse(string);
        }
        catch (VersionParsingException ignored) {
            return null;
        }
    }

    private Version(@NotNull int[] numbers, char suffixDelimiter, @Nullable String suffix) {
        if (0 == numbers.length) {
            throw new IllegalArgumentException("numbers is an empty array");
        }
        if (Arrays.binarySearch(ALLOWED_SUFFIX_DELIMITERS, suffixDelimiter) < 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALLOWED_SUFFIX_DELIMITERS.length; ++i) {
                if (i == 0) {
                    sb.append("suffixDelimiter must be one of ");
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append(ALLOWED_SUFFIX_DELIMITERS[i]).append('\'');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        for (int i = 0; i < numbers.length; ++i) {
            int number = numbers[i];
            if (number >= 0) continue;
            StringBuilder sb = new StringBuilder();
            if (0 == i) {
                sb.append("major");
            } else if (1 == i) {
                sb.append("minor");
            } else if (2 == i) {
                sb.append("patch");
            } else if (3 == i) {
                sb.append("build");
            } else {
                sb.append("numbers[").append(i).append(']');
            }
            sb.append(" < 0");
            throw new IllegalArgumentException(sb.toString());
        }
        this.numbers = (int[])numbers.clone();
        this.suffixDelimiter = suffixDelimiter;
        String string = this.suffix = suffix != null ? suffix : "";
        if (!this.suffix.isEmpty()) {
            ArrayList<SuffixToken> tokens = new ArrayList<SuffixToken>();
            String suffixLower = this.suffix.toLowerCase();
            Matcher matcher = SUFFIX_SPLITTER.matcher(suffixLower);
            int substringStart = 0;
            while (matcher.find()) {
                String number;
                if (substringStart < matcher.start()) {
                    tokens.add(new SuffixToken(suffixLower.substring(substringStart, matcher.start())));
                }
                if ((number = matcher.group(2)) != null) {
                    tokens.add(new SuffixToken(number, Long.parseUnsignedLong(number)));
                }
                substringStart = matcher.end();
            }
            if (substringStart < suffixLower.length()) {
                tokens.add(new SuffixToken(suffixLower.substring(substringStart)));
            }
            this.suffixTokens = tokens.toArray(new SuffixToken[0]);
            int suffixOrder = Integer.MIN_VALUE;
            long suffixSuborder = 0L;
            for (int i = 0; i < this.suffixTokens.length; ++i) {
                SuffixToken nextToken;
                Integer order;
                SuffixToken token = this.suffixTokens[i];
                if (token.number != null || (order = SUFFIX_ORDERS.get(token.string.toLowerCase())) == null || suffixOrder >= order) continue;
                suffixOrder = order;
                suffixSuborder = 0L;
                if (i + 1 >= this.suffixTokens.length || (nextToken = this.suffixTokens[i + 1]).number == null) continue;
                suffixSuborder = nextToken.number;
                ++i;
            }
            this.suffixOrder = Integer.MIN_VALUE == suffixOrder ? 0 : suffixOrder;
            this.suffixSuborder = suffixSuborder;
        } else {
            this.suffixTokens = EMPTY_SUFFIX_TOKENS;
            this.suffixOrder = 0;
            this.suffixSuborder = 0L;
        }
    }

    private Version(@NotNull int[] numbers, char suffixDelimiter, @NotNull String suffix, @NotNull SuffixToken[] suffixTokens, int suffixOrder, long suffixSuborder) {
        this.numbers = (int[])numbers.clone();
        this.suffixDelimiter = suffixDelimiter;
        this.suffix = suffix;
        this.suffixTokens = (SuffixToken[])suffixTokens.clone();
        this.suffixOrder = suffixOrder;
        this.suffixSuborder = suffixSuborder;
    }

    @JsonValue
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numbers.length; ++i) {
            if (1 <= i) {
                sb.append('.');
            }
            sb.append(this.numbers[i]);
        }
        if (!this.suffix.isEmpty()) {
            sb.append(this.suffixDelimiter).append(this.suffix);
        }
        return sb.toString();
    }

    public int getNumbersCount() {
        return this.numbers.length;
    }

    @Nullable
    public Integer getNumberOrNull(int index) {
        return index < this.numbers.length ? Integer.valueOf(this.numbers[index]) : null;
    }

    public int getNumberOr0(int index) {
        return index < this.numbers.length ? this.numbers[index] : 0;
    }

    @NotNull
    public Version withNumber(int index, int number) {
        if (index < this.numbers.length && number == this.numbers[index]) {
            return this;
        }
        int[] newNumbers = Arrays.copyOf(this.numbers, Math.max(this.numbers.length, index + 1));
        newNumbers[index] = number;
        return Version.createImpl(newNumbers, this.suffixDelimiter, this.suffix);
    }

    @NotNull
    public Version incrementNumber(int index, int delta) {
        return this.withNumber(index, this.getNumberOr0(index) + delta);
    }

    @NotNull
    public Version incrementNumber(int index) {
        return this.incrementNumber(index, 1);
    }

    @NotNull
    public Version withoutNumber(int index) {
        if (this.numbers.length <= index) {
            return this;
        }
        if (index <= 0) {
            throw new IllegalArgumentException("Version must contain at least one number");
        }
        int[] newNumbers = Arrays.copyOf(this.numbers, index);
        return Version.createImpl(newNumbers, this.suffixDelimiter, this.suffix);
    }

    @NotNull
    public int[] getNumbers() {
        return (int[])this.numbers.clone();
    }

    public int getMajor() {
        return this.numbers[0];
    }

    @NotNull
    public Version withMajor(int major) {
        return this.withNumber(0, major);
    }

    @NotNull
    public Version incrementMajor(int delta) {
        return this.incrementNumber(0, delta);
    }

    public boolean hasMinor() {
        return 1 < this.numbers.length;
    }

    @Nullable
    public Integer getMinor() {
        return this.getNumberOrNull(1);
    }

    @NotNull
    public Version withMinor(int minor) {
        return this.withNumber(1, minor);
    }

    @NotNull
    public Version incrementMinor(int delta) {
        return this.incrementNumber(1, delta);
    }

    @NotNull
    public Version incrementMinor() {
        return this.incrementMinor(1);
    }

    @NotNull
    public Version withoutMinor() {
        return this.withoutNumber(1);
    }

    public boolean hasPatch() {
        return 2 < this.numbers.length;
    }

    @Nullable
    public Integer getPatch() {
        return this.getNumberOrNull(2);
    }

    @NotNull
    public Version withPatch(int patch) {
        return this.withNumber(2, patch);
    }

    @NotNull
    public Version incrementPatch(int delta) {
        return this.incrementNumber(2, delta);
    }

    @NotNull
    public Version incrementPatch() {
        return this.incrementPatch(1);
    }

    @NotNull
    public Version withoutPatch() {
        return this.withoutNumber(2);
    }

    public boolean hasBuild() {
        return 3 < this.numbers.length;
    }

    @Nullable
    public Integer getBuild() {
        return this.getNumberOrNull(3);
    }

    @NotNull
    public Version withBuild(int build2) {
        return this.withNumber(3, build2);
    }

    @NotNull
    public Version incrementBuild(int delta) {
        return this.incrementNumber(3, delta);
    }

    @NotNull
    public Version incrementBuild() {
        return this.incrementBuild(1);
    }

    @NotNull
    public Version withoutBuild() {
        return this.withoutNumber(3);
    }

    public char getSuffixDelimiter() {
        return this.suffixDelimiter;
    }

    @NotNull
    public Version withSuffixDelimiter(char suffixDelimiter) {
        if (this.suffixDelimiter == suffixDelimiter) {
            return this;
        }
        return Version.createImpl(this.numbers, suffixDelimiter, this.suffix);
    }

    @NotNull
    public Version withDefaultSuffixDelimiter() {
        return this.withSuffixDelimiter('-');
    }

    public boolean hasSuffix() {
        return !this.suffix.isEmpty();
    }

    @NotNull
    public String getSuffix() {
        return this.suffix;
    }

    @NotNull
    public Version withSuffix(@Nullable String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        if (this.suffix.equals(suffix)) {
            return this;
        }
        return Version.createImpl(this.numbers, this.suffixDelimiter, suffix);
    }

    @NotNull
    public Version appendSuffix(@NotNull String suffixPart, @NotNull String delimiter) {
        if (this.suffix.isEmpty()) {
            return this.withSuffix(suffixPart);
        }
        return this.withSuffix(this.suffix + delimiter + suffixPart);
    }

    @NotNull
    public Version appendSuffix(@NotNull String suffixPart) {
        return this.appendSuffix(suffixPart, "");
    }

    @NotNull
    public Version prependSuffix(@NotNull String suffixPart, @NotNull String delimiter) {
        if (this.suffix.isEmpty()) {
            return this.withSuffix(suffixPart);
        }
        return this.withSuffix(suffixPart + delimiter + this.suffix);
    }

    @NotNull
    public Version prependSuffix(@NotNull String suffixPart) {
        return this.prependSuffix(suffixPart, "");
    }

    @NotNull
    public Version withoutSuffix() {
        return this.withSuffix("");
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (!Arrays.equals(this.numbers, other.numbers)) {
            return false;
        }
        if (this.suffixDelimiter != other.suffixDelimiter) {
            return false;
        }
        return this.suffix.equals(other.suffix);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.numbers) + Character.hashCode(this.suffixDelimiter) + this.suffix.hashCode();
    }

    @Override
    public int compareTo(@NotNull Version other) {
        int result;
        int i;
        int commonLength = Math.min(this.numbers.length, other.numbers.length);
        for (i = 0; i < commonLength; ++i) {
            result = Integer.compare(this.numbers[i], other.numbers[i]);
            if (0 == result) continue;
            return result;
        }
        if (commonLength < this.numbers.length) {
            return 1;
        }
        if (commonLength < other.numbers.length) {
            return -1;
        }
        if (this.suffix.equals(other.suffix)) {
            return 0;
        }
        int result2 = Integer.compare(this.suffixOrder, other.suffixOrder);
        if (0 == result2) {
            result2 = Long.compare(this.suffixSuborder, other.suffixSuborder);
        }
        if (0 != result2) {
            return result2;
        }
        commonLength = Math.min(this.suffixTokens.length, other.suffixTokens.length);
        for (i = 0; i < commonLength; ++i) {
            result = this.suffixTokens[i].compareTo(other.suffixTokens[i]);
            if (0 == result) continue;
            return result;
        }
        if (commonLength < this.suffixTokens.length) {
            return 1;
        }
        if (commonLength < other.suffixTokens.length) {
            return -1;
        }
        result2 = this.suffix.compareTo(other.suffix);
        if (0 != result2) {
            return result2;
        }
        return Character.compare(this.suffixDelimiter, other.suffixDelimiter);
    }

    @NotNull
    public Version clone() {
        return new Version(this.numbers, this.suffixDelimiter, this.suffix, this.suffixTokens, this.suffixOrder, this.suffixSuborder);
    }

    static {
        Arrays.sort(ALLOWED_SUFFIX_DELIMITERS);
        StringBuilder sb = new StringBuilder();
        sb.append("(\\d+(?:\\").append('.').append("\\d+)*)");
        sb.append("([");
        for (char ALLOWED_SUFFIX_DELIMITER : ALLOWED_SUFFIX_DELIMITERS) {
            sb.append('\\').append(ALLOWED_SUFFIX_DELIMITER);
        }
        sb.append("][\\S]+)?");
        VERSION_PATTERN = Pattern.compile(sb.toString());
        SUFFIX_SPLITTER = Pattern.compile("(?:(\\W+)|(\\d+))");
        EMPTY_SUFFIX_TOKENS = new SuffixToken[0];
        HashMap<String, Integer> suffixOrders = new HashMap<String, Integer>();
        int order = 0;
        suffixOrders.put("r", ++order);
        suffixOrders.put("release", order);
        suffixOrders.put("ga", order);
        suffixOrders.put("final", order);
        suffixOrders.put("sp", ++order);
        order = 0;
        suffixOrders.put("snapshot", --order);
        suffixOrders.put("nightly", --order);
        suffixOrders.put("rc", --order);
        suffixOrders.put("cr", order);
        suffixOrders.put("milestone", --order);
        suffixOrders.put("m", order);
        suffixOrders.put("beta", --order);
        suffixOrders.put("b", order);
        suffixOrders.put("alpha", --order);
        suffixOrders.put("a", order);
        suffixOrders.put("dev", --order);
        suffixOrders.put("pr", order);
        SUFFIX_ORDERS = Collections.unmodifiableMap(suffixOrders);
        V0 = new Version(new int[]{0}, '-', null);
        V1 = new Version(new int[]{1}, '-', null);
        V0_0 = new Version(new int[]{0, 0}, '-', null);
        V0_1 = new Version(new int[]{0, 1}, '-', null);
        V1_0 = new Version(new int[]{1, 0}, '-', null);
        V0_0_0 = new Version(new int[]{0, 0, 0}, '-', null);
        V0_0_1 = new Version(new int[]{0, 0, 1}, '-', null);
        V0_1_0 = new Version(new int[]{0, 1, 0}, '-', null);
        V1_0_0 = new Version(new int[]{1, 0, 0}, '-', null);
        V0_0_0_0 = new Version(new int[]{0, 0, 0, 0}, '-', null);
        V0_0_0_1 = new Version(new int[]{0, 0, 0, 1}, '-', null);
        V0_0_1_0 = new Version(new int[]{0, 0, 1, 0}, '-', null);
        V0_1_0_0 = new Version(new int[]{0, 1, 0, 0}, '-', null);
        V1_0_0_0 = new Version(new int[]{1, 0, 0, 0}, '-', null);
    }

    @SuppressFBWarnings
    protected /* synthetic */ Version() {
    }

    @Immutable
    private static final class SuffixToken
    implements Comparable<SuffixToken>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @NotNull
        private final String string;
        @Nullable
        private final Long number;

        private SuffixToken(@NotNull String string, @Nullable Long number) {
            this.string = string;
            this.number = number;
        }

        private SuffixToken(@NotNull String string) {
            this(string, (Long)null);
        }

        @Override
        public int compareTo(@NotNull SuffixToken other) {
            int result;
            if (this.number != null && other.number != null && 0 != (result = this.number.compareTo(other.number))) {
                return result;
            }
            return this.string.compareTo(other.string);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SuffixToken)) {
                return false;
            }
            SuffixToken that = (SuffixToken)o;
            return Objects.equals(this.string, that.string) && Objects.equals(this.number, that.number);
        }

        public int hashCode() {
            return Objects.hash(this.string, this.number);
        }

        public String toString() {
            return SuffixToken.class.getSimpleName() + '{' + "string='" + this.string + '\'' + ", number=" + this.number + '}';
        }

        @SuppressFBWarnings
        protected /* synthetic */ SuffixToken() {
        }
    }
}

