/*
 * Decompiled with CFR 0.152.
 */
package name.remal.version;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;
import name.remal.version.Version;
import name.remal.version.VersionRangeParsingException;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class VersionRange
implements Serializable,
Cloneable {
    @NotNull
    public static final VersionRange ANY_VERSION = new VersionRange(null, false, null, false);
    private static final long serialVersionUID = 1L;
    private static final String VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT = "Version range can't be parsed: '%s'. Only these formats are supported: '1.1+', '1.1.+', '[1,2]', '[1,2)', '(1,2]', '(1,2)'.";
    private static final String SUFFIXED_VERSIONS_CANT_BE_USED_MESSAGE_FORMAT = "Suffixed versions can't be used for version range: '%s'";
    @Nullable
    private final Version lowerBound;
    private final boolean lowerBoundInclusive;
    @Nullable
    private final Version upperBound;
    private final boolean upperBoundInclusive;

    @NotNull
    public static VersionRange create(@Nullable Version lowerBound, boolean lowerBoundInclusive, @Nullable Version upperBound, boolean upperBoundInclusive) {
        if (lowerBound == null && upperBound == null) {
            return ANY_VERSION;
        }
        return new VersionRange(lowerBound, lowerBoundInclusive, upperBound, upperBoundInclusive);
    }

    @NotNull
    public static VersionRange create(@NotNull Version version) {
        return new VersionRange(version, true, version, true);
    }

    @NotNull
    public static VersionRange greaterThan(@NotNull Version version) {
        return VersionRange.create(version, false, null, false);
    }

    @NotNull
    public static VersionRange greaterThanOrEqual(@NotNull Version version) {
        return VersionRange.create(version, true, null, false);
    }

    @NotNull
    public static VersionRange lessThan(@NotNull Version version) {
        return VersionRange.create(null, false, version, false);
    }

    @NotNull
    public static VersionRange lessThanOrEqual(@NotNull Version version) {
        return VersionRange.create(null, false, version, true);
    }

    @NotNull
    public static VersionRange parse(@NotNull String string) throws VersionRangeParsingException {
        if ((string = string.trim()).isEmpty()) {
            throw new VersionRangeParsingException("Blank string");
        }
        try {
            if ("+".equals(string)) {
                return ANY_VERSION;
            }
            if (string.contains("+")) {
                Version version;
                if (!string.endsWith("+")) {
                    throw new VersionRangeParsingException(String.format(VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT, string));
                }
                if (string.contains("[") || string.contains("(") || string.contains("]") || string.contains(")")) {
                    throw new VersionRangeParsingException(String.format(VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT, string));
                }
                String versionString = string.substring(0, string.length() - 1).trim();
                boolean endsWithDot = versionString.endsWith(".");
                if (endsWithDot) {
                    versionString = versionString.substring(0, versionString.length() - 1).trim();
                }
                if ((version = Version.parse(versionString)).hasSuffix()) {
                    throw new VersionRangeParsingException(String.format(SUFFIXED_VERSIONS_CANT_BE_USED_MESSAGE_FORMAT, string));
                }
                Version upperVersion = endsWithDot ? version.incrementNumber(version.getNumbersCount() - 1) : (version.getNumbersCount() >= 2 ? version.withoutNumber(version.getNumbersCount() - 1).incrementNumber(version.getNumbersCount() - 2) : null);
                return VersionRange.create(version, !endsWithDot, upperVersion, false);
            }
            if (string.contains("[") || string.contains("(") || string.contains("]") || string.contains(")")) {
                Version upperBound;
                String upperBoundString;
                Version lowerBound;
                if (!string.startsWith("[") && !string.startsWith("(")) {
                    throw new VersionRangeParsingException(String.format(VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT, string));
                }
                if (!string.endsWith("]") && !string.endsWith(")")) {
                    throw new VersionRangeParsingException(String.format(VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT, string));
                }
                int delimPos = string.indexOf(59);
                if (delimPos < 0) {
                    delimPos = string.indexOf(44);
                }
                if (delimPos < 0) {
                    throw new VersionRangeParsingException(String.format(VERSION_RAGE_CANT_BE_PARSED_MESSAGE_FORMAT, string));
                }
                String lowerBoundString = string.substring(1, delimPos).trim();
                if (!lowerBoundString.isEmpty()) {
                    lowerBound = Version.parse(lowerBoundString);
                    if (lowerBound.hasSuffix()) {
                        throw new VersionRangeParsingException(String.format(SUFFIXED_VERSIONS_CANT_BE_USED_MESSAGE_FORMAT, string));
                    }
                } else {
                    lowerBound = null;
                }
                if (!(upperBoundString = string.substring(delimPos + 1, string.length() - 1).trim()).isEmpty()) {
                    upperBound = Version.parse(upperBoundString);
                    if (upperBound.hasSuffix()) {
                        throw new VersionRangeParsingException(String.format(SUFFIXED_VERSIONS_CANT_BE_USED_MESSAGE_FORMAT, string));
                    }
                } else {
                    upperBound = null;
                }
                return VersionRange.create(lowerBound, string.startsWith("["), upperBound, string.endsWith("]"));
            }
            Version version = Version.parse(string);
            return VersionRange.create(version);
        }
        catch (Exception e) {
            throw e instanceof VersionRangeParsingException ? (VersionRangeParsingException)e : new VersionRangeParsingException(e);
        }
    }

    @JsonCreator
    @Nullable
    @Contract(value="null->null")
    public static VersionRange parseOrNull(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return VersionRange.parse(string);
        }
        catch (VersionRangeParsingException ignored) {
            return null;
        }
    }

    private VersionRange(@Nullable Version lowerBound, boolean lowerBoundInclusive, @Nullable Version upperBound, boolean upperBoundInclusive) {
        if (lowerBound != null && upperBound != null) {
            if (lowerBound.compareTo(upperBound) > 0) {
                throw new IllegalArgumentException(String.format("Lower bound version '%s' greater then upper bound '%s'", lowerBound, upperBound));
            }
            if (lowerBound.equals(upperBound) && (lowerBoundInclusive || upperBoundInclusive)) {
                lowerBoundInclusive = true;
                upperBoundInclusive = true;
            }
        }
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBound != null && lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBound != null && upperBoundInclusive;
    }

    public boolean contains(@NotNull Version version) {
        int comparisonResult;
        if (this.lowerBound != null) {
            comparisonResult = this.lowerBound.compareTo(version);
            if (this.lowerBoundInclusive && 0 < comparisonResult) {
                return false;
            }
            if (!this.lowerBoundInclusive && 0 <= comparisonResult) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparisonResult = this.upperBound.compareTo(version);
            if (this.upperBoundInclusive && comparisonResult < 0) {
                return false;
            }
            if (!this.upperBoundInclusive && comparisonResult <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(@NotNull VersionRange versionRange) {
        if (versionRange.lowerBound == null && versionRange.upperBound == null) {
            return this.lowerBound == null && this.upperBound == null;
        }
        if (versionRange.lowerBound != null && (!versionRange.lowerBoundInclusive && !this.lowerBoundInclusive ? !versionRange.lowerBound.equals(this.lowerBound) && !this.contains(versionRange.lowerBound) : !this.contains(versionRange.lowerBound))) {
            return false;
        }
        return versionRange.upperBound == null || !(!versionRange.upperBoundInclusive && !this.upperBoundInclusive ? !versionRange.upperBound.equals(this.upperBound) && !this.contains(versionRange.upperBound) : !this.contains(versionRange.upperBound));
    }

    public boolean isBoundToVersion() {
        return this.lowerBoundInclusive && this.upperBoundInclusive && this.lowerBound != null && this.lowerBound.equals(this.upperBound);
    }

    @Nullable
    public Version getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    @Nullable
    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    @JsonValue
    @NotNull
    public String toString() {
        if (this.lowerBound == null && this.upperBound == null) {
            return "+";
        }
        if (this.lowerBoundInclusive && this.upperBoundInclusive && this.lowerBound != null && this.lowerBound.equals(this.upperBound)) {
            return this.lowerBound.toString();
        }
        if (!this.upperBoundInclusive && this.lowerBound != null && this.upperBound != null) {
            int lowerBoundNumberCount = this.lowerBound.getNumbersCount();
            int upperBoundNumberCount = this.upperBound.getNumbersCount();
            if (!this.lowerBoundInclusive && lowerBoundNumberCount == upperBoundNumberCount) {
                if (this.upperBound.equals(this.lowerBound.incrementNumber(lowerBoundNumberCount - 1))) {
                    return this.lowerBound + ".+";
                }
            } else if (this.lowerBoundInclusive && lowerBoundNumberCount >= 2 && lowerBoundNumberCount - 1 == upperBoundNumberCount && this.upperBound.equals(this.lowerBound.withoutNumber(lowerBoundNumberCount - 1).incrementNumber(lowerBoundNumberCount - 2))) {
                return this.lowerBound + "+";
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.lowerBoundInclusive) {
            sb.append('[');
        } else {
            sb.append('(');
        }
        if (this.lowerBound != null) {
            sb.append(this.lowerBound);
        }
        sb.append(',');
        if (this.upperBound != null) {
            sb.append(this.upperBound);
        }
        if (this.upperBoundInclusive) {
            sb.append(']');
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (this.lowerBoundInclusive != other.lowerBoundInclusive) {
            return false;
        }
        if (this.upperBoundInclusive != other.upperBoundInclusive) {
            return false;
        }
        if (!Objects.equals(this.lowerBound, other.lowerBound)) {
            return false;
        }
        return Objects.equals(this.upperBound, other.upperBound);
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = 31 * result + Objects.hashCode(this.lowerBound);
        result = 31 * result + Boolean.hashCode(this.lowerBoundInclusive);
        result = 31 * result + Objects.hashCode(this.upperBound);
        result = 31 * result + Boolean.hashCode(this.upperBoundInclusive);
        return result;
    }

    @NotNull
    public VersionRange clone() {
        return new VersionRange(this.lowerBound, this.lowerBoundInclusive, this.upperBound, this.upperBoundInclusive);
    }

    @SuppressFBWarnings
    protected /* synthetic */ VersionRange() {
    }
}

