/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import name.remal.ArrayUtils;
import name.remal.PrimitiveTypeUtils;
import name.remal.SneakyThrow;
import name.remal.UncheckedCast;
import name.remal.annotation.AnnotationAttribute;
import name.remal.annotation.AnnotationAttributeAlias;
import name.remal.annotation.ErrorCreatingAnnotationInstanceException;
import name.remal.annotation.MetaAnnotationScanContext;
import name.remal.gradle_plugins.api.RelocateClasses;
import name.remal.proxy.CompositeInvocationHandler;
import name.remal.reflection.HierarchyUtils;
import name.remal.tools.common.internal._relocated.com.google.common.base.Joiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtils {
    public static boolean isLangCoreAnnotation(@NotNull Class<? extends Annotation> type) {
        String typeName = type.getName();
        if (typeName.startsWith("java.lang.")) {
            return true;
        }
        if (typeName.startsWith("kotlin.")) {
            return true;
        }
        if (typeName.startsWith("groovy.")) {
            return true;
        }
        return typeName.startsWith("scala.");
    }

    @NotNull
    public static @NotNull List<@NotNull Method> getAttributeMethods(@NotNull Class<? extends Annotation> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || 0 != method.getParameterCount() || Void.TYPE == method.getReturnType()) continue;
            result.add(method);
        }
        return result;
    }

    @NotNull
    @RelocateClasses(value={Joiner.class})
    public static <T extends Annotation> T newAnnotationInstance(@NotNull Class<T> type, @Nullable Map<String, Object> attributes) {
        List<Method> attributeMethods = AnnotationUtils.getAttributeMethods(type);
        attributeMethods.forEach(method -> method.setAccessible(true));
        HashMap fullAttributes = new HashMap();
        attributeMethods.forEach(attributeMethod -> {
            Object value;
            String attributeName = attributeMethod.getName();
            Object object = value = attributes != null ? (Object)attributes.get(attributeName) : null;
            if (value == null) {
                value = attributeMethod.getDefaultValue();
            }
            if (value == null) {
                throw new IllegalArgumentException("Missing value for " + attributeName);
            }
            if (!PrimitiveTypeUtils.wrap(attributeMethod.getReturnType()).isInstance(value)) {
                throw new ErrorCreatingAnnotationInstanceException((Class<? extends Annotation>)type, String.format("Attribute %s must be %s, but %s provided", attributeName, PrimitiveTypeUtils.unwrap(attributeMethod.getReturnType()), PrimitiveTypeUtils.unwrap(value.getClass())));
            }
            fullAttributes.put(attributeName, value);
        });
        if (attributes != null) {
            LinkedHashSet<String> unknownAttrs = new LinkedHashSet<String>();
            for (String string : attributes.keySet()) {
                if (fullAttributes.containsKey(string)) continue;
                unknownAttrs.add(string);
            }
            if (!unknownAttrs.isEmpty()) {
                if (1 == unknownAttrs.size()) {
                    throw new ErrorCreatingAnnotationInstanceException(type, "Unknown attribute: " + (String)unknownAttrs.iterator().next());
                }
                throw new ErrorCreatingAnnotationInstanceException(type, "Unknown attribute: " + Joiner.on(", ").join(unknownAttrs));
            }
        }
        int value = 0;
        for (Map.Entry entry : fullAttributes.entrySet()) {
            value += 127 * ((String)entry.getKey()).hashCode() ^ ArrayUtils.arrayHashCode(entry.getValue());
        }
        int hashCode = value;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@').append(type.getName()).append('(');
        boolean isFirst = true;
        for (Map.Entry entry : fullAttributes.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey()).append('=').append(ArrayUtils.arrayToString(entry.getValue()));
        }
        stringBuilder.append(')');
        String stringRepresentation = stringBuilder.toString();
        return (T)((Annotation)UncheckedCast.uncheckedCast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new CompositeInvocationHandler().appendEqualsHandler((proxy, other) -> {
            if (!type.isInstance(other)) {
                return false;
            }
            for (Method attributeMethod : attributeMethods) {
                if (ArrayUtils.arrayEquals(fullAttributes.get(attributeMethod.getName()), attributeMethod.invoke(other, new Object[0]))) continue;
                return false;
            }
            return true;
        }).appendHashCodeHandler(hashCode).appendToStringHandler(stringRepresentation).appendConstMethodHandler(method -> 0 == method.getParameterCount() && "annotationType".equals(method.getName()), type).appendMethodHandler(method -> 0 == method.getParameterCount() && fullAttributes.containsKey(method.getName()), (proxy, method, args) -> fullAttributes.get(method.getName())))));
    }

    @NotNull
    public static <T extends Annotation> @NotNull Map<@NotNull String, @NotNull Object> getAttributes(@NotNull T annotation) {
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
        for (Method method : AnnotationUtils.getAttributeMethods(annotation.annotationType())) {
            method.setAccessible(true);
            try {
                attrs.put(method.getName(), method.invoke(annotation, new Object[0]));
            }
            catch (Throwable throwable) {
                throw SneakyThrow.sneakyThrow(throwable);
            }
        }
        return attrs;
    }

    @NotNull
    public static <T extends Annotation> T withAttributes(@NotNull T annotation, @Nullable Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return annotation;
        }
        HashMap<String, Object> fullAttributes = new HashMap<String, Object>(AnnotationUtils.getAttributes(annotation));
        fullAttributes.putAll(attributes);
        return AnnotationUtils.newAnnotationInstance((Class)UncheckedCast.uncheckedCast(annotation.annotationType()), fullAttributes);
    }

    public static <T extends Annotation> boolean canAnnotate(@NotNull Class<T> type, @NotNull ElementType elementType) {
        Target target = type.getDeclaredAnnotation(Target.class);
        return target == null || ArrayUtils.contains((Object[])target.value(), (Object)elementType);
    }

    public static boolean canAnnotate(@NotNull Class<? extends Annotation> type, @NotNull AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Annotation) {
            return AnnotationUtils.canAnnotate(type, ElementType.ANNOTATION_TYPE);
        }
        if (annotatedElement instanceof Class) {
            return AnnotationUtils.canAnnotate(type, ElementType.TYPE);
        }
        if (annotatedElement instanceof Field) {
            return AnnotationUtils.canAnnotate(type, ElementType.FIELD);
        }
        if (annotatedElement instanceof Method) {
            return AnnotationUtils.canAnnotate(type, ElementType.METHOD);
        }
        if (annotatedElement instanceof Parameter) {
            return AnnotationUtils.canAnnotate(type, ElementType.PARAMETER);
        }
        if (annotatedElement instanceof Constructor) {
            return AnnotationUtils.canAnnotate(type, ElementType.CONSTRUCTOR);
        }
        if (annotatedElement instanceof Package) {
            return AnnotationUtils.canAnnotate(type, ElementType.PACKAGE);
        }
        if (annotatedElement instanceof AnnotatedTypeVariable) {
            return AnnotationUtils.canAnnotate(type, ElementType.TYPE_PARAMETER) || AnnotationUtils.canAnnotate(type, ElementType.TYPE_USE);
        }
        if (annotatedElement instanceof AnnotatedType) {
            return AnnotationUtils.canAnnotate(type, ElementType.TYPE_USE);
        }
        return false;
    }

    @Nullable
    public static <T extends Annotation> T getMetaAnnotation(@NotNull AnnotatedElement annotatedElement, @NotNull Class<T> type) {
        List<T> annotations = AnnotationUtils.getMetaAnnotationsImpl(annotatedElement, type, true);
        if (!annotations.isEmpty()) {
            return (T)((Annotation)annotations.get(0));
        }
        return null;
    }

    @NotNull
    public static <T extends Annotation> @NotNull List<@NotNull T> getMetaAnnotations(@NotNull AnnotatedElement annotatedElement, @NotNull Class<T> type) {
        return AnnotationUtils.getMetaAnnotationsImpl(annotatedElement, type, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @SuppressFBWarnings(value={"CAIL_POSSIBLE_CONSTANT_ALLOCATION_IN_LOOP", "PCAIL_POSSIBLE_CONSTANT_ALLOCATION_IN_LOOP"})
    private static <T extends Annotation> @NotNull List<@NotNull T> getMetaAnnotationsImpl(@NotNull AnnotatedElement rootAnnotatedElement, @NotNull Class<T> type, boolean doReturnOnlyFirst) {
        MetaAnnotationScanContext metaAnnotationScanContext;
        LinkedHashSet<Annotation> result = null;
        boolean canAnnotateAnnotations = AnnotationUtils.canAnnotate(type, ElementType.ANNOTATION_TYPE);
        HashSet<MetaAnnotationScanContext> processedMetaAnnotationScanContexts = new HashSet<MetaAnnotationScanContext>();
        LinkedList<MetaAnnotationScanContext> annotatedElementsQueue = new LinkedList<MetaAnnotationScanContext>();
        annotatedElementsQueue.add(new MetaAnnotationScanContext(rootAnnotatedElement, null));
        while ((metaAnnotationScanContext = (MetaAnnotationScanContext)annotatedElementsQueue.poll()) != null) {
            List<AnnotatedElement> hierarchy;
            void var13_20;
            Object resultAnnotation;
            if (!processedMetaAnnotationScanContexts.add(metaAnnotationScanContext)) continue;
            AnnotatedElement annotatedElement = metaAnnotationScanContext.getAnnotatedElement();
            List<AnnotationAttribute> attributes = metaAnnotationScanContext.getAttributes();
            T annotation = annotatedElement.getDeclaredAnnotation(type);
            if (annotation != null) {
                resultAnnotation = AnnotationUtils.withAttributes(annotation, attributes);
                if (doReturnOnlyFirst) {
                    return Collections.singletonList(resultAnnotation);
                }
                if (result == null) {
                    result = new LinkedHashSet<Annotation>();
                }
                result.add((Annotation)resultAnnotation);
            }
            ArrayList<T> otherDeclaredAnnotations = new ArrayList<T>();
            resultAnnotation = annotatedElement.getDeclaredAnnotations();
            int n = ((T)resultAnnotation).length;
            boolean bl = false;
            while (var13_20 < n) {
                T t = resultAnnotation[var13_20];
                Class<? extends Annotation> annotationType = t.annotationType();
                if (type != annotationType && !AnnotationUtils.isLangCoreAnnotation(annotationType)) {
                    otherDeclaredAnnotations.add(t);
                }
                ++var13_20;
            }
            for (Annotation annotation3 : otherDeclaredAnnotations) {
                Annotation[] values;
                Method method;
                List<Method> list = AnnotationUtils.getAttributeMethods(annotation3.annotationType());
                if (1 != list.size() || !(method = list.get(0)).getReturnType().isArray() || type != method.getReturnType().getComponentType() || !"value".equals(method.getName())) continue;
                method.setAccessible(true);
                try {
                    values = (Annotation[])UncheckedCast.uncheckedCast(method.invoke((Object)annotation3, new Object[0]));
                }
                catch (Throwable throwable) {
                    throw SneakyThrow.sneakyThrow(throwable);
                }
                for (Annotation value : values) {
                    Annotation resultAnnotation2 = AnnotationUtils.withAttributes(value, attributes);
                    if (doReturnOnlyFirst) {
                        return Collections.singletonList(resultAnnotation2);
                    }
                    if (result == null) {
                        result = new LinkedHashSet();
                    }
                    result.add(resultAnnotation2);
                }
            }
            if (canAnnotateAnnotations) {
                for (Annotation annotation4 : otherDeclaredAnnotations) {
                    void var14_31;
                    Class<? extends Annotation> clazz = annotation4.annotationType();
                    Object var14_30 = null;
                    for (Method attributeMethod : AnnotationUtils.getAttributeMethods(clazz)) {
                        for (AnnotationAttributeAlias alias : (AnnotationAttributeAlias[])attributeMethod.getDeclaredAnnotationsByType(AnnotationAttributeAlias.class)) {
                            if (var14_31 == null) {
                                ArrayList<AnnotationAttribute> arrayList = new ArrayList<AnnotationAttribute>();
                                if (attributes != null) {
                                    arrayList.addAll(attributes);
                                }
                            }
                            Object value = null;
                            if (attributes != null) {
                                for (AnnotationAttribute attr : attributes) {
                                    if (clazz != attr.getAnnotationType() || !Objects.equals(attributeMethod.getName(), attr.getName())) continue;
                                    value = attr.getValue();
                                    break;
                                }
                            }
                            if (value == null) {
                                attributeMethod.setAccessible(true);
                                try {
                                    value = attributeMethod.invoke((Object)annotation4, new Object[0]);
                                }
                                catch (Throwable throwable) {
                                    throw SneakyThrow.sneakyThrow(throwable);
                                }
                            }
                            var14_31.add(new AnnotationAttribute(alias.annotationClass(), alias.attributeName(), value));
                        }
                    }
                    annotatedElementsQueue.add(new MetaAnnotationScanContext(clazz, (List<AnnotationAttribute>)(var14_31 != null ? var14_31 : attributes)));
                }
            }
            if (rootAnnotatedElement != annotatedElement || type.getDeclaredAnnotation(Inherited.class) == null) continue;
            if (annotatedElement instanceof Parameter) {
                hierarchy = HierarchyUtils.getHierarchy((Parameter)annotatedElement);
                if (2 > hierarchy.size()) continue;
                for (AnnotatedElement annotatedElement2 : hierarchy.subList(1, hierarchy.size())) {
                    annotatedElementsQueue.add(new MetaAnnotationScanContext(annotatedElement2, attributes));
                }
                continue;
            }
            if (annotatedElement instanceof Method) {
                hierarchy = HierarchyUtils.getHierarchy((Method)annotatedElement);
                if (2 > hierarchy.size()) continue;
                for (AnnotatedElement annotatedElement3 : hierarchy.subList(1, hierarchy.size())) {
                    annotatedElementsQueue.add(new MetaAnnotationScanContext(annotatedElement3, attributes));
                }
                continue;
            }
            if (!(annotatedElement instanceof Class)) continue;
            hierarchy = (List)UncheckedCast.uncheckedCast(HierarchyUtils.getHierarchy((Class)annotatedElement));
            if (2 <= hierarchy.size()) {
                for (Class clazz : hierarchy.subList(1, hierarchy.size())) {
                    if (Object.class == clazz) continue;
                    annotatedElementsQueue.add(new MetaAnnotationScanContext(clazz, attributes));
                }
            }
            if (!AnnotationUtils.canAnnotate(type, ElementType.PACKAGE)) continue;
            for (Class clazz : hierarchy) {
                for (Package curPackage : HierarchyUtils.getPackageHierarchy(clazz)) {
                    annotatedElementsQueue.add(new MetaAnnotationScanContext(curPackage, attributes));
                }
            }
        }
        return result == null ? Collections.emptyList() : new ArrayList(result);
    }

    @NotNull
    private static <T extends Annotation> T withAttributes(@NotNull T annotation, @Nullable Collection<AnnotationAttribute> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return annotation;
        }
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        Class annotationType = (Class)UncheckedCast.uncheckedCast(annotation.annotationType());
        for (AnnotationAttribute attr : attributes) {
            if (annotationType != attr.getAnnotationType()) continue;
            attrsMap.putIfAbsent(attr.getName(), attr.getValue());
        }
        AnnotationUtils.getAttributes(annotation).forEach(attrsMap::putIfAbsent);
        return AnnotationUtils.newAnnotationInstance(annotationType, attrsMap);
    }
}

