/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Arrays;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationEnumValue;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class BytecodeAnnotationEnumsArrayValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final BytecodeAnnotationEnumValue[] EMPTY = new BytecodeAnnotationEnumValue[0];
    private static final long serialVersionUID = 1L;
    @NotNull
    private BytecodeAnnotationEnumValue[] value = EMPTY;

    public BytecodeAnnotationEnumsArrayValue() {
    }

    @Contract(value="null->fail")
    public BytecodeAnnotationEnumsArrayValue(BytecodeAnnotationEnumValue ... value) {
        Objects.requireNonNull(value);
        for (int i = 0; i < value.length; ++i) {
            Objects.requireNonNull(value[i], "value[" + i + ']');
        }
        this.value = value;
    }

    @NotNull
    public BytecodeAnnotationEnumValue[] getValue() {
        return this.value;
    }

    @Contract(value="null->fail")
    public void setValue(@NotNull BytecodeAnnotationEnumValue[] value) {
        Objects.requireNonNull(value);
        for (int i = 0; i < value.length; ++i) {
            Objects.requireNonNull(value[i], "value[" + i + ']');
        }
        this.value = value;
    }

    @NotNull
    @Contract(value="null->fail")
    public BytecodeAnnotationEnumsArrayValue addItem(@NotNull BytecodeAnnotationEnumValue item) {
        BytecodeAnnotationEnumValue[] newValue = new BytecodeAnnotationEnumValue[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = Objects.requireNonNull(item);
        this.value = newValue;
        return this;
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationEnumsArrayValue)) {
            return false;
        }
        BytecodeAnnotationEnumsArrayValue that = (BytecodeAnnotationEnumsArrayValue)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValue());
    }

    @Override
    public boolean isEnumsArray() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationEnumsArrayValue asEnumsArray() {
        return this;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.value == null) {
            throw new InvalidObjectException("value is null");
        }
        for (int i = 0; i < this.value.length; ++i) {
            Objects.requireNonNull(this.value[i], "value[" + i + ']');
            try {
                this.value[i].validateObject();
                continue;
            }
            catch (InvalidObjectException e) {
                throw new InvalidObjectException("value[" + i + "]: " + e.getMessage());
            }
        }
    }
}

