/*
 * Decompiled with CFR 0.152.
 */
package name.remal.annotation.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.util.Objects;
import name.remal.annotation.bytecode.BytecodeAnnotationValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnnotationStringValue
extends BytecodeAnnotationValue
implements ObjectInputValidation {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String value;

    @Contract(value="null->fail")
    public BytecodeAnnotationStringValue(@NotNull String value) {
        this.value = Objects.requireNonNull(value);
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Contract(value="null->fail")
    public void setValue(@NotNull String value) {
        this.value = Objects.requireNonNull(value);
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytecodeAnnotationStringValue)) {
            return false;
        }
        BytecodeAnnotationStringValue that = (BytecodeAnnotationStringValue)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    @NotNull
    public BytecodeAnnotationStringValue asString() {
        return this;
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    private BytecodeAnnotationStringValue() {
        this.value = null;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.value == null) {
            throw new InvalidObjectException("value is null");
        }
    }
}

