/*
 * Decompiled with CFR 0.152.
 */
package name.remal.collections;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import name.remal.SneakyThrow;
import name.remal.collections.ElementAddedHandler;
import name.remal.collections.ElementRemovedHandler;
import name.remal.collections.EntryAddedHandler;
import name.remal.collections.EntryRemovedHandler;
import name.remal.collections.HandlerRegistration;
import name.remal.collections.ObservableCollection;
import name.remal.collections.ObservableList;
import name.remal.collections.ObservableMap;
import name.remal.collections.ObservableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObservableCollections {
    @NotNull
    public static <E> ObservableCollection<E> observableCollection(@NotNull Collection<E> collection) {
        return new WrappedObservableCollection(collection);
    }

    @NotNull
    public static <E> ObservableList<E> observableList(@NotNull List<E> list) {
        return new WrappedObservableList(list);
    }

    @NotNull
    public static <E> ObservableSet<E> observableSet(@NotNull Set<E> set) {
        return new WrappedObservableSet(set);
    }

    @NotNull
    public static <K, V> ObservableMap<K, V> observableMap(@NotNull Map<K, V> map) {
        return new WrappedObservableMap(map);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "NFF_NON_FUNCTIONAL_FIELD", "NP_STORE_INTO_NONNULL_FIELD"})
    private static class WrappedObservableMap<K, V>
    implements ObservableMap<K, V>,
    Serializable,
    ObjectInputValidation {
        private static final long serialVersionUID = 1L;
        @NotNull
        private final Map<K, V> delegate;
        @NotNull
        private final transient List<EntryAddedHandler<K, V>> entryAddedHandlers = new ArrayList<EntryAddedHandler<K, V>>();
        @NotNull
        private final transient List<EntryRemovedHandler<K, V>> entryRemovedHandlers = new ArrayList<EntryRemovedHandler<K, V>>();

        private WrappedObservableMap(@NotNull Map<K, V> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate can't be null");
        }

        private WrappedObservableMap() {
            this.delegate = null;
        }

        @Override
        public void validateObject() throws InvalidObjectException {
            if (this.delegate == null) {
                throw new InvalidObjectException("delegate can't be null");
            }
        }

        @Override
        @NotNull
        public HandlerRegistration registerEntryAddedHandler(@NotNull EntryAddedHandler<K, V> handler) {
            this.entryAddedHandlers.add(handler);
            return () -> this.entryAddedHandlers.removeIf(it -> it == handler);
        }

        private void invokeEntryAddedHandlers(K key, V value) {
            try {
                for (EntryAddedHandler<K, V> handler : this.entryAddedHandlers) {
                    handler.onEntryAdded(key, value);
                }
            }
            catch (Throwable throwable) {
                throw SneakyThrow.sneakyThrow(throwable);
            }
        }

        @Override
        @NotNull
        public HandlerRegistration registerEntryRemovedHandler(@NotNull EntryRemovedHandler<K, V> handler) {
            this.entryRemovedHandlers.add(handler);
            return () -> this.entryRemovedHandlers.removeIf(it -> it == handler);
        }

        private void invokeEntryRemovedHandlers(K key, V value) {
            try {
                for (EntryRemovedHandler<K, V> handler : this.entryRemovedHandlers) {
                    handler.onEntryRemoved(key, value);
                }
            }
            catch (Throwable throwable) {
                throw SneakyThrow.sneakyThrow(throwable);
            }
        }

        @Override
        @Nullable
        public V put(K key, V value) {
            boolean containsKey = this.delegate.containsKey(key);
            V prev = this.delegate.put(key, value);
            if (!containsKey) {
                this.invokeEntryAddedHandlers(key, value);
            } else if (!Objects.equals(prev, value)) {
                this.invokeEntryRemovedHandlers(key, prev);
                this.invokeEntryAddedHandlers(key, value);
            }
            return prev;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public V remove(Object key) {
            boolean containsKey = this.delegate.containsKey(key);
            V prev = this.delegate.remove(key);
            if (containsKey) {
                this.invokeEntryRemovedHandlers(key, prev);
            }
            return prev;
        }

        @Override
        public void clear() {
            ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(this.delegate.entrySet());
            this.delegate.clear();
            for (Map.Entry entry : entries) {
                this.invokeEntryRemovedHandlers(entry.getKey(), entry.getValue());
            }
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return new AbstractSet<K>(){
                private final Set<K> delegateKeySet;
                {
                    this.delegateKeySet = delegate.keySet();
                }

                @Override
                public boolean remove(Object o) {
                    boolean contains = delegate.containsKey(o);
                    Object prev = delegate.remove(o);
                    if (contains) {
                        this.invokeEntryRemovedHandlers(o, prev);
                    }
                    return contains;
                }

                @Override
                @NotNull
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private final Iterator<Map.Entry<K, V>> delegateIterator;
                        {
                            this.delegateIterator = this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegateIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.delegateIterator.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.delegateIterator.remove();
                        }
                    };
                }

                @Override
                public void clear() {
                    this.clear();
                }

                @Override
                public int size() {
                    return this.delegateKeySet.size();
                }

                @Override
                public boolean contains(Object o) {
                    return this.delegateKeySet.contains(o);
                }
            };
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return new AbstractCollection<V>(){
                private final Collection<V> delegateValues;
                {
                    this.delegateValues = delegate.values();
                }

                @Override
                public boolean remove(Object o) {
                    for (Map.Entry entry : delegate.entrySet()) {
                        if (!Objects.equals(o, entry.getValue())) continue;
                        this.remove(entry.getKey());
                        return true;
                    }
                    return false;
                }

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Map.Entry<K, V>> delegateIterator;
                        {
                            this.delegateIterator = this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegateIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.delegateIterator.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.delegateIterator.remove();
                        }
                    };
                }

                @Override
                public void clear() {
                    this.clear();
                }

                @Override
                public int size() {
                    return this.delegateValues.size();
                }

                @Override
                public boolean contains(Object o) {
                    return this.delegateValues.contains(o);
                }
            };
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){
                private final Set<Map.Entry<K, V>> delegateEntrySet;
                {
                    this.delegateEntrySet = delegate.entrySet();
                }

                @Override
                @NotNull
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, V>> delegateIterator;
                        @Nullable
                        private Map.Entry<K, V> lastReturned;
                        {
                            this.delegateIterator = delegateEntrySet.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegateIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            this.lastReturned = this.delegateIterator.next();
                            return this.lastReturned;
                        }

                        @Override
                        public void remove() {
                            this.delegateIterator.remove();
                            if (this.lastReturned != null) {
                                this.invokeEntryRemovedHandlers(this.lastReturned.getKey(), this.lastReturned.getValue());
                            }
                            this.lastReturned = null;
                        }
                    };
                }

                @Override
                public boolean remove(Object o) {
                    boolean result = this.delegateEntrySet.remove(o);
                    if (result) {
                        this.invokeEntryRemovedHandlers(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                    }
                    return result;
                }

                @Override
                public void clear() {
                    this.clear();
                }

                @Override
                public int size() {
                    return this.delegateEntrySet.size();
                }

                @Override
                public boolean contains(Object o) {
                    return this.delegateEntrySet.contains(o);
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WrappedObservableMap)) {
                return false;
            }
            WrappedObservableMap that = (WrappedObservableMap)o;
            return Objects.equals(this.delegate, that.delegate);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private static class WrappedObservableSet<E>
    extends BaseWrappedObservableCollection<E, Set<E>>
    implements ObservableSet<E> {
        private static final long serialVersionUID = 1L;

        private WrappedObservableSet(@NotNull Set<E> delegate) {
            super(delegate);
        }

        private WrappedObservableSet() {
        }
    }

    private static class WrappedObservableList<E>
    extends BaseWrappedObservableCollection<E, List<E>>
    implements ObservableList<E> {
        private static final long serialVersionUID = 1L;

        private WrappedObservableList(@NotNull List<E> delegate) {
            super(delegate);
        }

        private WrappedObservableList() {
        }

        @Override
        public E set(int index, E element) {
            E prev = ((List)this.delegate).set(index, element);
            if (!Objects.equals(prev, element)) {
                this.invokeElementRemovedHandlers(prev);
                this.invokeElementAddedHandlers(element);
            }
            return prev;
        }

        @Override
        public void add(int index, E element) {
            ((List)this.delegate).add(index, element);
            this.invokeElementAddedHandlers(element);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends E> c) {
            boolean result = ((List)this.delegate).addAll(index, c);
            if (result) {
                for (E e : c) {
                    this.invokeElementAddedHandlers(e);
                }
            }
            return result;
        }

        @Override
        public E remove(int index) {
            Object prev = ((List)this.delegate).remove(index);
            this.invokeElementRemovedHandlers(prev);
            return prev;
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<E> delegateIterator;
                @Nullable
                private E lastReturned;
                {
                    this.delegateIterator = ((List)delegate).listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public E next() {
                    this.lastReturned = this.delegateIterator.next();
                    return this.lastReturned;
                }

                @Override
                public boolean hasPrevious() {
                    return this.delegateIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    this.lastReturned = this.delegateIterator.previous();
                    return this.lastReturned;
                }

                @Override
                public int nextIndex() {
                    return this.delegateIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.delegateIterator.previousIndex();
                }

                @Override
                public void remove() {
                    this.delegateIterator.remove();
                    this.invokeElementRemovedHandlers(this.lastReturned);
                    this.lastReturned = null;
                }

                @Override
                public void set(E e) {
                    Object prev = this.get(this.nextIndex() - 1);
                    this.delegateIterator.set(e);
                    if (!Objects.equals(prev, e)) {
                        this.invokeElementRemovedHandlers(prev);
                        this.invokeElementAddedHandlers(e);
                    }
                }

                @Override
                public void add(E e) {
                    this.delegateIterator.add(e);
                    this.invokeElementAddedHandlers(e);
                }
            };
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public E get(int index) {
            return ((List)this.delegate).get(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.delegate).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.delegate).lastIndexOf(o);
        }

        @Override
        @NotNull
        public List<E> subList(int fromIndex, int toIndex) {
            return ((List)this.delegate).subList(fromIndex, toIndex);
        }
    }

    private static class WrappedObservableCollection<E>
    extends BaseWrappedObservableCollection<E, Collection<E>> {
        private static final long serialVersionUID = 1L;

        private WrappedObservableCollection(@NotNull Collection<E> delegate) {
            super(delegate);
        }

        private WrappedObservableCollection() {
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "NFF_NON_FUNCTIONAL_FIELD", "NP_STORE_INTO_NONNULL_FIELD"})
    private static abstract class BaseWrappedObservableCollection<E, C extends Collection<E>>
    implements ObservableCollection<E>,
    Serializable,
    ObjectInputValidation {
        private static final long serialVersionUID = 1L;
        @NotNull
        protected final C delegate;
        @NotNull
        private final transient List<ElementAddedHandler<E>> elementAddedHandlers = new ArrayList<ElementAddedHandler<E>>();
        @NotNull
        private final transient List<ElementRemovedHandler<E>> elementRemovedHandlers = new ArrayList<ElementRemovedHandler<E>>();

        protected BaseWrappedObservableCollection(@NotNull C delegate) {
            this.delegate = (Collection)Objects.requireNonNull(delegate, "delegate can't be null");
        }

        protected BaseWrappedObservableCollection() {
            this.delegate = null;
        }

        @Override
        public void validateObject() throws InvalidObjectException {
            if (this.delegate == null) {
                throw new InvalidObjectException("delegate can't be null");
            }
        }

        @Override
        @NotNull
        public HandlerRegistration registerElementAddedHandler(@NotNull ElementAddedHandler<E> handler) {
            this.elementAddedHandlers.add(handler);
            return () -> this.elementAddedHandlers.removeIf(it -> it == handler);
        }

        protected void invokeElementAddedHandlers(@Nullable E element) {
            if (element != null) {
                try {
                    for (ElementAddedHandler<E> handler : this.elementAddedHandlers) {
                        handler.onElementAdded(element);
                    }
                }
                catch (Throwable throwable) {
                    throw SneakyThrow.sneakyThrow(throwable);
                }
            }
        }

        @Override
        @NotNull
        public HandlerRegistration registerElementRemovedHandler(@NotNull ElementRemovedHandler<E> handler) {
            this.elementRemovedHandlers.add(handler);
            return () -> this.elementRemovedHandlers.removeIf(it -> it == handler);
        }

        protected void invokeElementRemovedHandlers(@Nullable E element) {
            if (element != null) {
                try {
                    for (ElementRemovedHandler<E> handler : this.elementRemovedHandlers) {
                        handler.onElementRemoved(element);
                    }
                }
                catch (Throwable throwable) {
                    throw SneakyThrow.sneakyThrow(throwable);
                }
            }
        }

        @Override
        public boolean add(E e) {
            boolean result = this.delegate.add(e);
            if (result) {
                this.invokeElementAddedHandlers(e);
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = this.delegate.remove(o);
            if (result) {
                this.invokeElementRemovedHandlers(o);
            }
            return result;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<E> delegateIterator;
                @Nullable
                private E lastReturned;
                {
                    this.delegateIterator = delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public E next() {
                    this.lastReturned = this.delegateIterator.next();
                    return this.lastReturned;
                }

                @Override
                public void remove() {
                    this.delegateIterator.remove();
                    this.invokeElementRemovedHandlers(this.lastReturned);
                    this.lastReturned = null;
                }
            };
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends E> c) {
            boolean result = false;
            for (E e : c) {
                result |= this.add(e);
            }
            return result;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            boolean result = false;
            for (Object e : c) {
                result |= this.remove(e);
            }
            return result;
        }

        @Override
        public void clear() {
            Object[] elements = this.toArray();
            this.delegate.clear();
            for (Object element : elements) {
                this.invokeElementRemovedHandlers(element);
            }
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            boolean result = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E element = iterator.next();
                if (c.contains(element)) continue;
                iterator.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseWrappedObservableCollection)) {
                return false;
            }
            BaseWrappedObservableCollection that = (BaseWrappedObservableCollection)o;
            return Objects.equals(this.delegate, that.delegate);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

