/*
 * Decompiled with CFR 0.152.
 */
package name.remal.log;

import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final boolean IS_SLF4J_IN_CLASSPATH = LogUtils.isSlf4JInClasspath();

    public static boolean isTraceLogEnabled(@NotNull String loggerName) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).isTraceEnabled();
        }
        return false;
    }

    public static boolean isTraceLogEnabled(@NotNull Class<?> loggerClass) {
        return LogUtils.isTraceLogEnabled(loggerClass.getName());
    }

    public static void logTrace(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(message);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logTrace(loggerClass.getName(), message);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(message, throwable);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logTrace(loggerClass.getName(), message, throwable);
    }

    public static void logTrace(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).trace(throwable.toString(), throwable);
        }
    }

    public static void logTrace(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logTrace(loggerClass.getName(), throwable);
    }

    public static boolean isDebugLogEnabled(@NotNull String loggerName) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).isDebugEnabled();
        }
        return false;
    }

    public static boolean isDebugLogEnabled(@NotNull Class<?> loggerClass) {
        return LogUtils.isDebugLogEnabled(loggerClass.getName());
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(message);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logDebug(loggerClass.getName(), message);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(message, throwable);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logDebug(loggerClass.getName(), message, throwable);
    }

    public static void logDebug(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).debug(throwable.toString(), throwable);
        }
    }

    public static void logDebug(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logDebug(loggerClass.getName(), throwable);
    }

    public static boolean isInfoLogEnabled(@NotNull String loggerName) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).isInfoEnabled();
        }
        return true;
    }

    public static boolean isInfoLogEnabled(@NotNull Class<?> loggerClass) {
        return LogUtils.isInfoLogEnabled(loggerClass.getName());
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(message);
        } else {
            System.out.println(message);
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logInfo(loggerClass.getName(), message);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(message, throwable);
        } else {
            System.out.println(message);
            System.out.println(throwable.toString());
            throwable.printStackTrace(System.out);
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logInfo(loggerClass.getName(), message, throwable);
    }

    public static void logInfo(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).info(throwable.toString(), throwable);
        } else {
            System.out.println(throwable.toString());
            throwable.printStackTrace(System.out);
        }
    }

    public static void logInfo(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logInfo(loggerClass.getName(), throwable);
    }

    public static boolean isWarnLogEnabled(@NotNull String loggerName) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).isWarnEnabled();
        }
        return true;
    }

    public static boolean isWarnLogEnabled(@NotNull Class<?> loggerClass) {
        return LogUtils.isWarnLogEnabled(loggerClass.getName());
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(message);
        } else {
            System.err.println(message);
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logWarn(loggerClass.getName(), message);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(message, throwable);
        } else {
            System.err.println(message);
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logWarn(loggerClass.getName(), message, throwable);
    }

    public static void logWarn(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).warn(throwable.toString(), throwable);
        } else {
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void logWarn(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logWarn(loggerClass.getName(), throwable);
    }

    public static boolean isErrorLogEnabled(@NotNull String loggerName) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).isErrorEnabled();
        }
        return true;
    }

    public static boolean isErrorLogEnabled(@NotNull Class<?> loggerClass) {
        return LogUtils.isErrorLogEnabled(loggerClass.getName());
    }

    public static void logError(@NotNull String loggerName, @NotNull String message) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(message);
        } else {
            System.err.println(message);
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message) {
        LogUtils.logError(loggerClass.getName(), message);
    }

    public static void logError(@NotNull String loggerName, @NotNull String message, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(message, throwable);
        } else {
            System.err.println(message);
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull String message, @NotNull Throwable throwable) {
        LogUtils.logError(loggerClass.getName(), message, throwable);
    }

    public static void logError(@NotNull String loggerName, @NotNull Throwable throwable) {
        if (IS_SLF4J_IN_CLASSPATH) {
            LoggerFactory.getLogger((String)loggerName).error(throwable.toString(), throwable);
        } else {
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void logError(@NotNull Class<?> loggerClass, @NotNull Throwable throwable) {
        LogUtils.logError(loggerClass.getName(), throwable);
    }

    private static boolean isSlf4JInClasspath() {
        try {
            Class.forName("org.slf4j.LoggerFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

