/*
 * Decompiled with CFR 0.152.
 */
package name.valery1707.kaitai;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import name.valery1707.kaitai.KaitaiException;
import name.valery1707.kaitai.KaitaiUtils;
import name.valery1707.kaitai.LogWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.buildobjects.process.ExternalProcessFailureException;
import org.buildobjects.process.ProcBuilder;
import org.buildobjects.process.StartupException;
import org.buildobjects.process.TimeoutException;
import org.slf4j.Logger;

public class KaitaiGenerator {
    private final Path kaitai;
    private final Path output;
    private final String packageName;
    private final Set<Path> sources = new LinkedHashSet<Path>();
    private boolean overwrite = false;
    private boolean exactOutput = false;
    private final ByteArrayOutputStream streamError = new ByteArrayOutputStream(256);
    private final ByteArrayOutputStream streamOutput = new ByteArrayOutputStream(256);
    private long executionTimeout = 5000L;
    private String fromFileClass;
    private Boolean opaqueTypes;
    private boolean noVersionCheck;

    public static KaitaiGenerator generator(Path kaitai, Path output, String packageName) throws KaitaiException {
        KaitaiUtils.checkFileIsExecutable(kaitai);
        KaitaiUtils.checkDirectoryIsWritable(output);
        return new KaitaiGenerator(kaitai, output, packageName);
    }

    private KaitaiGenerator(Path kaitai, Path output, String packageName) {
        this.kaitai = kaitai;
        this.output = output;
        this.packageName = packageName;
    }

    public Path getKaitai() {
        return this.kaitai;
    }

    public Path getOutput() {
        return this.output;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<Path> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public KaitaiGenerator withSource(Path source) throws KaitaiException {
        KaitaiUtils.checkFileIsReadable(source);
        this.sources.add(source);
        return this;
    }

    public KaitaiGenerator withSource(Iterable<Path> sources) throws KaitaiException {
        for (Path source : sources) {
            this.withSource(source);
        }
        return this;
    }

    public KaitaiGenerator withSource(Path ... sources) throws KaitaiException {
        return this.withSource(Arrays.asList(sources));
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public KaitaiGenerator overwrite(boolean overwrite) {
        this.setOverwrite(overwrite);
        return this;
    }

    public boolean isExactOutput() {
        return this.exactOutput;
    }

    public void setExactOutput(boolean exactOutput) {
        this.exactOutput = exactOutput;
    }

    public KaitaiGenerator exactOutput(boolean exactOutput) {
        this.setExactOutput(exactOutput);
        return this;
    }

    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public KaitaiGenerator executionTimeout(long executionTimeout) {
        this.setExecutionTimeout(executionTimeout);
        return this;
    }

    public String getFromFileClass() {
        return this.fromFileClass;
    }

    public void setFromFileClass(String fromFileClass) {
        this.fromFileClass = StringUtils.trimToNull((String)fromFileClass);
    }

    public KaitaiGenerator fromFileClass(String fromFileClass) {
        this.setFromFileClass(fromFileClass);
        return this;
    }

    public Boolean getOpaqueTypes() {
        return this.opaqueTypes;
    }

    public void setOpaqueTypes(Boolean opaqueTypes) {
        this.opaqueTypes = opaqueTypes;
    }

    public KaitaiGenerator opaqueTypes(Boolean opaqueTypes) {
        this.setOpaqueTypes(opaqueTypes);
        return this;
    }

    public boolean isNoVersionCheck() {
        return this.noVersionCheck;
    }

    public void setNoVersionCheck(boolean noVersionCheck) {
        this.noVersionCheck = noVersionCheck;
    }

    public KaitaiGenerator noVersionCheck(boolean noVersionCheck) {
        this.setNoVersionCheck(noVersionCheck);
        return this;
    }

    private ProcBuilder process(Logger log) {
        ProcBuilder builder = new ProcBuilder(this.getKaitai().normalize().toAbsolutePath().toString(), new String[0]).withErrorStream((OutputStream)new TeeOutputStream(LogWriter.logError(log), (OutputStream)this.streamError)).withOutputStream((OutputStream)new TeeOutputStream(LogWriter.logInfo(log), (OutputStream)this.streamOutput)).withExpectedExitStatuses(new int[]{0});
        if (this.getExecutionTimeout() < 0L) {
            builder.withNoTimeout();
        } else {
            builder.withTimeoutMillis(this.getExecutionTimeout());
        }
        if (this.isNoVersionCheck()) {
            if (SystemUtils.IS_OS_WINDOWS) {
                log.info("Option `noVersionCheck` is ignored on Windows");
            } else {
                builder.withArgs(new String[]{"-no-version-check"});
            }
        }
        return builder;
    }

    private void execute(ProcBuilder builder) throws KaitaiException {
        try {
            this.streamError.reset();
            this.streamOutput.reset();
            builder.run();
        }
        catch (ExternalProcessFailureException | StartupException | TimeoutException e) {
            throw new KaitaiException("Fail to execute kaitai command: " + new String(this.streamError.toByteArray(), StandardCharsets.UTF_8) + new String(this.streamOutput.toByteArray(), StandardCharsets.UTF_8), e);
        }
    }

    public Path generate(Logger log) throws KaitaiException {
        if (!this.isOverwrite()) {
            // empty if block
        }
        log.info("Kaitai: check version");
        this.execute(this.process(log).withArg("--version"));
        Path output = this.getOutput().normalize();
        if (this.isExactOutput()) {
            output = KaitaiUtils.createTempDirectory("kaitai-" + this.getPackageName(), new FileAttribute[0]);
        }
        ProcBuilder builder = this.process(log).withArgs(new String[]{"--target", "java"}).withArgs(new String[]{"--outdir", output.toFile().getAbsolutePath()}).withArgs(new String[]{"--java-package", this.getPackageName()});
        if (StringUtils.isNotBlank((CharSequence)this.getFromFileClass())) {
            builder.withArgs(new String[]{"--java-from-file-class", this.getFromFileClass()});
        }
        if (this.getOpaqueTypes() != null) {
            builder.withArgs(new String[]{"--opaque-types", this.getOpaqueTypes().toString()});
        }
        for (Path source : this.getSources()) {
            builder.withArg(source.normalize().toFile().getAbsolutePath());
        }
        log.info("Kaitai: generate");
        this.execute(builder);
        output = output.resolve("src");
        if (this.isExactOutput()) {
            Path root = this.getOutput();
            List<Path> generated = KaitaiUtils.scanFiles(output, new String[]{"*"}, new String[0]);
            KaitaiUtils.move(output, generated, root);
            KaitaiUtils.delete(output);
            return root;
        }
        return output;
    }
}

