/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.digester.Digester;
import org.codehaus.nanning.attribute.AttributeException;
import org.codehaus.nanning.attribute.Attributes;
import org.codehaus.nanning.attribute.AttributesLoader;
import org.codehaus.nanning.attribute.ClassAttributes;
import org.codehaus.nanning.attribute.ClassPropertiesHelper;
import org.xml.sax.SAXException;

public class AttributesXMLParser
implements AttributesLoader {
    private String fieldName;
    private String methodName;
    private String argumentList;
    private ClassPropertiesHelper classPropertiesHelper;

    public void load(ClassAttributes classAttributes) {
        this.classPropertiesHelper = new ClassPropertiesHelper(classAttributes);
        Class aClass = classAttributes.getAttributeClass();
        InputStream input = null;
        try {
            input = Attributes.findFile((Class)aClass, (String)(this.classPropertiesHelper.getClassName() + ".xml"));
            if (input == null) {
                input = Attributes.findFile((Class)aClass, (String)(aClass.getName().replace('.', '/') + ".xml"));
            }
            if (input != null) {
                this.parse(input);
            }
        }
        catch (MalformedURLException e) {
            throw new AttributeException("Error fetching properties for " + aClass, (Throwable)e);
        }
        catch (IOException e) {
            throw new AttributeException("Error fetching properties for " + aClass, (Throwable)e);
        }
        catch (AttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeException("Error fetching properties for " + aClass, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new AttributeException((Throwable)e);
                }
            }
        }
    }

    private void parse(InputStream input) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.addCallMethod("*/attribute", "setAttributeValue", 2);
        digester.addCallParam("*/attribute/name", 0);
        digester.addCallParam("*/attribute/value", 1);
        digester.addSetProperties("attributes/method", "name", "methodName");
        digester.addCallMethod("attributes/method/parameter-type", "addArgumentType", 0);
        digester.addSetProperties("attributes/field", "name", "fieldName");
        digester.push((Object)this);
        digester.parse(input);
    }

    public void setAttributeValue(String name, String value) {
        if (this.fieldName != null) {
            this.classPropertiesHelper.loadFieldAttribute(this.fieldName, name, value);
        } else if (this.methodName != null) {
            String methodSignature = this.methodName + "(" + (this.argumentList == null ? "" : this.argumentList) + ")";
            this.classPropertiesHelper.loadMethodAttribute(methodSignature, name, value);
        } else {
            this.classPropertiesHelper.loadClassAttribute(name, value);
        }
        this.fieldName = null;
        this.methodName = null;
        this.argumentList = null;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public void addArgumentType(String type) {
        if (this.argumentList == null) {
            this.argumentList = type;
        } else {
            this.argumentList = this.argumentList + ",";
            this.argumentList = this.argumentList + type;
        }
    }
}

