/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import org.nanocontainer.remoting.jmx.DynamicMBeanComponentProvider;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapter;

public class JMXExposingComponentAdapter
extends DecoratingComponentAdapter {
    private final MBeanServer mBeanServer;
    private final DynamicMBeanProvider[] providers;

    public JMXExposingComponentAdapter(ComponentAdapter delegate, MBeanServer mBeanServer, DynamicMBeanProvider[] providers) throws NullPointerException {
        super(delegate);
        if (mBeanServer == null || providers == null) {
            throw new NullPointerException();
        }
        this.mBeanServer = mBeanServer;
        this.providers = providers;
    }

    public JMXExposingComponentAdapter(ComponentAdapter delegate, MBeanServer mBeanServer) throws NullPointerException {
        this(delegate, mBeanServer, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        CachingComponentAdapter componentAdapter = new CachingComponentAdapter(this.getDelegate());
        Object componentInstance = componentAdapter.getComponentInstance(container);
        for (int i = 0; i < this.providers.length; ++i) {
            JMXRegistrationInfo info = this.providers[i].provide(container, (ComponentAdapter)componentAdapter);
            if (info == null) continue;
            JMException exception = null;
            try {
                this.mBeanServer.registerMBean(info.getMBean(), info.getObjectName());
            }
            catch (InstanceAlreadyExistsException e) {
                exception = e;
            }
            catch (MBeanRegistrationException e) {
                exception = e;
            }
            catch (NotCompliantMBeanException e) {
                exception = e;
            }
            if (exception == null) continue;
            throw new PicoInitializationException("Registering MBean failed", (Throwable)exception);
        }
        return componentInstance;
    }
}

