/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb;

import java.util.List;
import javax.sql.DataSource;
import net.lab1024.smartdb.SmartDb;
import net.lab1024.smartdb.SmartDbConfig;
import net.lab1024.smartdb.SmartDbFactory;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.ext.SmartDbExtEnum;
import net.lab1024.smartdb.filter.SmartDbFilter;
import net.lab1024.smartdb.mapping.rowconvertor.RowConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.TableNameConverter;

public class SmartDbBuilder
extends SmartDbConfig {
    protected String url;
    protected String username;
    protected String password;
    protected String driverClassName;
    private DataSource masterDataSource;
    private DataSource[] slaveDataSource;

    public SmartDb build() {
        return SmartDbFactory.build(this);
    }

    public static SmartDbBuilder create() {
        return new SmartDbBuilder();
    }

    public SmartDbBuilder setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public SmartDbBuilder setTableNameConverter(TableNameConverter tableNameConverter) {
        this.tableNameConverter = tableNameConverter;
        return this;
    }

    public SmartDbBuilder addSmartDbFilter(SmartDbFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        if (this.filters.contains(filter)) {
            throw new IllegalArgumentException("exist filter " + filter);
        }
        this.filters.add(filter);
        return this;
    }

    public DataSource getMasterDataSource() {
        return this.masterDataSource;
    }

    public DataSource[] getSlaveDataSource() {
        return this.slaveDataSource;
    }

    public void setFilters(List<SmartDbFilter> filters) {
        this.filters = filters;
    }

    public SmartDbBuilder setSmartDbExtEnum(SmartDbExtEnum ext) {
        this.smartDbExtEnum = ext;
        return this;
    }

    public SmartDbBuilder setSupportDatabaseType(SupportDatabaseType sqlType) {
        if (sqlType == null) {
            throw new IllegalArgumentException("sqltype cannot be null");
        }
        this.supportDatabaseType = sqlType;
        return this;
    }

    public SmartDbBuilder setMasterDataSource(DataSource ds) {
        this.masterDataSource = ds;
        return this;
    }

    public SmartDbBuilder setSlaveDataSource(DataSource ... ds) {
        this.slaveDataSource = ds;
        return this;
    }

    public SmartDbBuilder setColumnNameConverter(ColumnNameConverter columnNameConverter) {
        this.columnNameConverter = columnNameConverter;
        return this;
    }

    public SmartDbBuilder setRowConverter(RowConverter rowConverter) {
        this.rowConverter = rowConverter;
        return this;
    }

    public SmartDbBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public SmartDbBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public SmartDbBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public SmartDbBuilder setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }
}

