/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.ext.spring;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import net.lab1024.smartdb.SmartDb;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.pagination.PaginateParam;
import net.lab1024.smartdb.pagination.PaginateResult;
import net.lab1024.smartdb.sqlbuilder.DeleteSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SelectSqlBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SmartDbDaoSupport<T> {
    @Autowired
    protected SmartDb smartDb;
    protected Class<T> entityClass;

    public SmartDbDaoSupport() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new SmartDbException("pls use Generic Type for class : " + this.getClass().getName());
        }
        this.entityClass = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public long count() {
        SelectSqlBuilder selectSqlBuilder = this.smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("count(1)");
        selectSqlBuilder.from(classMeta.getTableName(this.smartDb.getTableNameConverter()));
        return this.smartDb.query(ScalarHandler.Long, selectSqlBuilder);
    }

    public List<T> batchInsert(List<T> list) {
        return this.smartDb.batchInsert(list);
    }

    public List<T> selectAll() {
        SelectSqlBuilder selectSqlBuilder = this.smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(this.smartDb.getTableNameConverter()));
        return this.smartDb.queryList(this.entityClass, selectSqlBuilder);
    }

    public T selectByPrimaryKey(Serializable ... keys) {
        SelectSqlBuilder selectSqlBuilder = this.smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(this.smartDb.getTableNameConverter()));
        SupportDatabaseType supportDatabaseType = this.smartDb.getSupportDatabaseType();
        OrmClassFieldMeta[] primaryFields = classMeta.getPrimaryKeyFields();
        for (int i = 0; i < primaryFields.length; ++i) {
            OrmClassFieldMeta f = primaryFields[i];
            String name = f.getOrmColumnName();
            selectSqlBuilder.whereAnd(String.format("%s = ?", supportDatabaseType.getSqlBuilderFactory().wrapSpecialCharacterField(name)), keys[i]);
        }
        return this.smartDb.queryFirst(this.entityClass, selectSqlBuilder);
    }

    public PaginateResult<T> paginate(PaginateParam paginateParam) {
        SelectSqlBuilder selectSqlBuilder = this.smartDb.selectSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        selectSqlBuilder.select("*");
        selectSqlBuilder.from(classMeta.getTableName(this.smartDb.getTableNameConverter()));
        return this.smartDb.paginate(this.entityClass, paginateParam, selectSqlBuilder);
    }

    public int delete(T t) {
        return this.smartDb.delete(t);
    }

    public int deleteAll() {
        return this.smartDb.deleteSqlBuilder().table(this.entityClass).execute();
    }

    public int deleteByPrimaryKey(Serializable ... keys) {
        DeleteSqlBuilder deleteSqlBuilder = this.smartDb.deleteSqlBuilder();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(this.entityClass);
        deleteSqlBuilder.table(classMeta.getTableName(this.smartDb.getTableNameConverter()));
        SupportDatabaseType supportDatabaseType = this.smartDb.getSupportDatabaseType();
        OrmClassFieldMeta[] primaryFields = classMeta.getPrimaryKeyFields();
        for (int i = 0; i < primaryFields.length; ++i) {
            OrmClassFieldMeta f = primaryFields[i];
            String name = f.getOrmColumnName();
            deleteSqlBuilder.whereAnd(String.format("%s = ?", supportDatabaseType.getSqlBuilderFactory().wrapSpecialCharacterField(name)), keys[i]);
        }
        return this.smartDb.execute(deleteSqlBuilder);
    }

    public int updateSelective(T t) {
        return this.smartDb.updateSelective(t);
    }

    public int update(T t) {
        return this.smartDb.update(t);
    }

    public T insert(T t) {
        return this.smartDb.insert(t);
    }

    public T insertSelective(T t) {
        return this.smartDb.insertSelective(t);
    }
}

